/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.client.subsystem.sftp.impl.AbstractSftpClient;
import org.apache.sshd.client.subsystem.sftp.impl.SftpAckData;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.subsystem.sftp.SftpHelper;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.io.InputStreamWithChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpInputStreamAsync
extends InputStreamWithChannel {
    protected final Logger log;
    protected final byte[] bb = new byte[1];
    protected final int bufferSize;
    protected final long fileSize;
    protected Buffer buffer;
    protected SftpClient.CloseableHandle handle;
    protected long requestOffset;
    protected long clientOffset;
    protected final Deque<SftpAckData> pendingReads = new LinkedList<SftpAckData>();
    protected boolean eofIndicator;
    private final AbstractSftpClient clientInstance;
    private final String path;

    public SftpInputStreamAsync(AbstractSftpClient client, int bufferSize, String path, Collection<SftpClient.OpenMode> mode) throws IOException {
        this.log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        this.clientInstance = Objects.requireNonNull(client, "No SFTP client instance");
        this.path = path;
        this.handle = client.open(path, mode);
        this.bufferSize = bufferSize;
        this.fileSize = client.stat(this.handle).getSize();
    }

    public SftpInputStreamAsync(AbstractSftpClient client, int bufferSize, long clientOffset, long fileSize, String path, SftpClient.CloseableHandle handle) {
        this.log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        this.clientInstance = Objects.requireNonNull(client, "No SFTP client instance");
        this.path = path;
        this.handle = handle;
        this.bufferSize = bufferSize;
        this.clientOffset = clientOffset;
        this.fileSize = fileSize;
    }

    public final AbstractSftpClient getClient() {
        return this.clientInstance;
    }

    public final String getPath() {
        return this.path;
    }

    public boolean isEof() {
        return this.eofIndicator && this.hasNoData();
    }

    public boolean isOpen() {
        return this.handle != null && this.handle.isOpen();
    }

    public int read() throws IOException {
        int read = this.read(this.bb, 0, 1);
        if (read > 0) {
            return this.bb[0] & 0xFF;
        }
        return read;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int res;
        if (!this.isOpen()) {
            throw new IOException("read(" + this.getPath() + ") stream closed");
        }
        int idx = off;
        while (len > 0 && !this.eofIndicator) {
            if (this.hasNoData()) {
                this.fillData();
                if (this.eofIndicator && this.hasNoData()) break;
                this.sendRequests();
                continue;
            }
            int nb = Math.min(this.buffer.available(), len);
            this.buffer.getRawBytes(b, off, nb);
            off += nb;
            len -= nb;
            this.clientOffset += (long)nb;
        }
        if ((res = off - idx) == 0 && this.eofIndicator) {
            res = -1;
        }
        return res;
    }

    public long transferTo(long max, WritableByteChannel out) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("transferTo(" + this.getPath() + ") stream closed");
        }
        long orgOffset = this.clientOffset;
        long totalRequested = max;
        while (!this.eofIndicator && max > 0L) {
            if (this.hasNoData()) {
                this.fillData();
                if (this.eofIndicator && this.hasNoData()) break;
                this.sendRequests();
                continue;
            }
            int nb = this.buffer.available();
            int toRead = (int)Math.min((long)nb, max);
            ByteBuffer bb = ByteBuffer.wrap(this.buffer.array(), this.buffer.rpos(), toRead);
            while (bb.hasRemaining()) {
                out.write(bb);
            }
            this.buffer.rpos(this.buffer.rpos() + toRead);
            this.clientOffset += (long)toRead;
            max -= (long)toRead;
        }
        long numXfered = this.clientOffset - orgOffset;
        if (this.log.isDebugEnabled()) {
            this.log.debug("transferTo({}) transferred {}/{} bytes", (Object)numXfered, (Object)totalRequested);
        }
        return numXfered;
    }

    public long transferTo(OutputStream out) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("transferTo(" + this.getPath() + ") stream closed");
        }
        long orgOffset = this.clientOffset;
        while (!this.eofIndicator) {
            if (this.hasNoData()) {
                this.fillData();
                if (this.eofIndicator && this.hasNoData()) break;
                this.sendRequests();
                continue;
            }
            int nb = this.buffer.available();
            out.write(this.buffer.array(), this.buffer.rpos(), nb);
            this.buffer.rpos(this.buffer.rpos() + nb);
            this.clientOffset += (long)nb;
        }
        long numXfered = this.clientOffset - orgOffset;
        if (this.log.isDebugEnabled()) {
            this.log.debug("transferTo({}) transferred {} bytes", (Object)this, (Object)numXfered);
        }
        return numXfered;
    }

    public long skip(long n) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("skip(" + this.getPath() + ") stream closed");
        }
        if (this.clientOffset == 0L && this.pendingReads.isEmpty()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("skip({}) virtual skip of {} bytes", (Object)this, (Object)n);
            }
            this.clientOffset = n;
            return n;
        }
        return super.skip(n);
    }

    protected boolean hasNoData() {
        return this.buffer == null || this.buffer.available() == 0;
    }

    protected void sendRequests() throws IOException {
        if (this.eofIndicator) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendRequests({}) EOF indicator ON", (Object)this);
            }
            return;
        }
        AbstractSftpClient client = this.getClient();
        Channel channel = client.getChannel();
        Window localWindow = channel.getLocalWindow();
        long windowSize = localWindow.getMaxSize();
        ClientSession session = client.getSession();
        byte[] id = this.handle.getIdentifier();
        boolean traceEnabled = this.log.isTraceEnabled();
        int ackIndex = 1;
        while (this.pendingReads.size() < (int)(windowSize / (long)this.bufferSize) && this.requestOffset < this.fileSize + (long)this.bufferSize || this.pendingReads.isEmpty()) {
            Buffer buf = session.createBuffer((byte)94, 39 + id.length);
            buf.rpos(23);
            buf.wpos(23);
            buf.putBytes(id);
            buf.putLong(this.requestOffset);
            buf.putInt((long)this.bufferSize);
            int reqId = client.send(5, buf);
            SftpAckData ack = new SftpAckData(reqId, this.requestOffset, this.bufferSize);
            if (traceEnabled) {
                this.log.trace("sendRequests({}) enqueue pending ack #{}: {}", new Object[]{this, ackIndex, ack});
            }
            this.pendingReads.add(ack);
            this.requestOffset += (long)this.bufferSize;
            ++ackIndex;
        }
    }

    protected void fillData() throws IOException {
        SftpAckData ack = this.pendingReads.pollFirst();
        boolean traceEnabled = this.log.isTraceEnabled();
        if (ack == null) {
            if (traceEnabled) {
                this.log.trace("fillData({}) no pending ack", (Object)this);
            }
            return;
        }
        if (traceEnabled) {
            this.log.trace("fillData({}) process ack={}", (Object)this, (Object)ack);
        }
        this.pollBuffer(ack);
        if (!this.eofIndicator && this.clientOffset < ack.offset) {
            int dlen;
            byte[] data = new byte[(int)(ack.offset - this.clientOffset + (long)this.buffer.available())];
            int nb = (int)(ack.offset - this.clientOffset);
            if (traceEnabled) {
                this.log.trace("fillData({}) reading {} bytes", (Object)this, (Object)nb);
            }
            AtomicReference<Boolean> eof = new AtomicReference<Boolean>();
            AbstractSftpClient client = this.getClient();
            for (int cur = 0; cur < nb; cur += dlen) {
                dlen = client.read(this.handle, this.clientOffset, data, cur, nb - cur, eof);
                Boolean eofSignal = eof.getAndSet(null);
                if (dlen >= 0 && (eofSignal == null || !eofSignal.booleanValue())) continue;
                this.eofIndicator = true;
            }
            if (traceEnabled) {
                this.log.trace("fillData({}) read {} bytes - EOF={}", new Object[]{this, nb, this.eofIndicator});
            }
            this.buffer.getRawBytes(data, nb, this.buffer.available());
            this.buffer = new ByteArrayBuffer(data);
        }
    }

    protected void pollBuffer(SftpAckData ack) throws IOException {
        boolean traceEnabled = this.log.isTraceEnabled();
        if (traceEnabled) {
            this.log.trace("pollBuffer({}) polling ack={}", (Object)this, (Object)ack);
        }
        AbstractSftpClient client = this.getClient();
        Buffer buf = client.receive(ack.id);
        int length = buf.getInt();
        int type = buf.getUByte();
        int id = buf.getInt();
        if (traceEnabled) {
            this.log.trace("pollBuffer({}) response={} for ack={} - len={}", new Object[]{this, type, ack, length});
        }
        client.validateIncomingResponse(94, id, type, length, buf);
        if (type == 103) {
            int dlen = buf.getInt();
            int rpos = buf.rpos();
            buf.rpos(rpos + dlen);
            Boolean b = SftpHelper.getEndOfFileIndicatorValue(buf, client.getVersion());
            if (b != null && b.booleanValue()) {
                this.eofIndicator = true;
            }
            buf.rpos(rpos);
            buf.wpos(rpos + dlen);
            this.buffer = buf;
        } else if (type == 101) {
            int substatus = buf.getInt();
            String msg = buf.getString();
            String lang = buf.getString();
            if (substatus == 1) {
                this.eofIndicator = true;
            } else {
                client.checkResponseStatus(94, id, substatus, msg, lang);
            }
        } else {
            IOException err = client.handleUnexpectedPacket(94, 101, id, type, length, buf);
            if (err != null) {
                throw err;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.isOpen()) {
            return;
        }
        try {
            boolean debugEnabled = this.log.isDebugEnabled();
            try {
                int ackIndex = 1;
                while (!this.pendingReads.isEmpty()) {
                    SftpAckData ack = this.pendingReads.removeFirst();
                    if (debugEnabled) {
                        this.log.debug("close({}) process ack #{}: {}", new Object[]{this, ackIndex, ack});
                    }
                    this.pollBuffer(ack);
                    ++ackIndex;
                }
            }
            finally {
                if (debugEnabled) {
                    this.log.debug("close({}) closing file handle", (Object)this);
                }
                this.handle.close();
            }
        }
        finally {
            this.handle = null;
        }
    }

    public String toString() {
        AbstractSftpClient client = this.getClient();
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + client.getSession() + "][" + this.getPath() + "]";
    }
}

