/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.memoize;

import aQute.lib.memoize.MemoizingSupplier;
import aQute.lib.memoize.PredicateMemoizingSupplier;
import aQute.lib.memoize.ReferenceMemoizingSupplier;
import aQute.lib.memoize.RefreshingMemoizingSupplier;
import java.lang.ref.Reference;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface Memoize<S>
extends Supplier<S> {
    public static <T> Memoize<T> supplier(Supplier<? extends T> supplier) {
        if (supplier instanceof MemoizingSupplier) {
            Memoize memoized = (Memoize)supplier;
            return memoized;
        }
        return new MemoizingSupplier<T>(supplier);
    }

    public static <T, R> Memoize<R> supplier(Function<? super T, ? extends R> function, T argument) {
        Objects.requireNonNull(function);
        return Memoize.supplier(() -> function.apply((Object)argument));
    }

    public static <T> Memoize<T> refreshingSupplier(Supplier<? extends T> supplier, long time_to_live, TimeUnit unit) {
        return new RefreshingMemoizingSupplier<T>(supplier, time_to_live, unit);
    }

    public static <T> Memoize<T> referenceSupplier(Supplier<? extends T> supplier, Function<? super T, ? extends Reference<? extends T>> reference) {
        return new ReferenceMemoizingSupplier<T>(supplier, reference);
    }

    public static <T> Memoize<T> predicateSupplier(Supplier<? extends T> supplier, Predicate<? super T> predicate) {
        return new PredicateMemoizingSupplier<T>(supplier, predicate);
    }

    public S peek();

    default public <R> Memoize<R> map(Function<? super S, ? extends R> mapper) {
        Objects.requireNonNull(mapper);
        return Memoize.supplier(() -> mapper.apply((S)this.get()));
    }

    default public <R> Memoize<R> flatMap(Function<? super S, ? extends Supplier<? extends R>> mapper) {
        Objects.requireNonNull(mapper);
        return Memoize.supplier(() -> ((Supplier)mapper.apply((S)this.get())).get());
    }

    default public Memoize<S> filter(Predicate<? super S> predicate) {
        Objects.requireNonNull(predicate);
        return Memoize.supplier(() -> {
            Object value = this.get();
            return predicate.test((S)value) ? value : null;
        });
    }

    default public Memoize<S> accept(Consumer<? super S> consumer) {
        Objects.requireNonNull(consumer);
        consumer.accept(this.get());
        return this;
    }
}

