/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryOperator;
import org.javamoney.moneta.RoundedMoney;
import org.javamoney.moneta.function.MonetaryOperators;
import org.javamoney.moneta.spi.MonetaryAmountProducer;

public final class RoundedMoneyProducer
implements MonetaryAmountProducer {
    private final MonetaryOperator operator;

    public RoundedMoneyProducer(MonetaryOperator operator) {
        this.operator = Objects.requireNonNull(operator);
    }

    public RoundedMoneyProducer() {
        this.operator = MonetaryOperators.rounding();
    }

    @Override
    public MonetaryAmount create(CurrencyUnit currency, Number number) {
        return RoundedMoney.of(Objects.requireNonNull(number), Objects.requireNonNull(currency), this.operator);
    }

    public MonetaryOperator getOperator() {
        return this.operator;
    }
}

