/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.schema.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.JsonMetaSchema;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.Keyword;
import com.networknt.schema.NonValidationKeyword;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.services.ScopeService;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.apache.unomi.schema.api.JsonSchemaWrapper;
import org.apache.unomi.schema.api.SchemaService;
import org.apache.unomi.schema.keyword.ScopeKeyword;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaServiceImpl
implements SchemaService {
    private static final String URI = "https://json-schema.org/draft/2019-09/schema";
    private static final Logger logger = LoggerFactory.getLogger((String)SchemaServiceImpl.class.getName());
    private static final String TARGET_EVENTS = "events";
    ObjectMapper objectMapper = new ObjectMapper();
    private final ConcurrentMap<String, JsonSchemaWrapper> predefinedUnomiJSONSchemaById = new ConcurrentHashMap<String, JsonSchemaWrapper>();
    private ConcurrentMap<String, JsonSchemaWrapper> schemasById = new ConcurrentHashMap<String, JsonSchemaWrapper>();
    private ConcurrentMap<String, Set<String>> extensions = new ConcurrentHashMap<String, Set<String>>();
    private Integer jsonSchemaRefreshInterval = 1000;
    private ScheduledFuture<?> scheduledFuture;
    private PersistenceService persistenceService;
    private ScopeService scopeService;
    private JsonSchemaFactory jsonSchemaFactory;
    private ScheduledExecutorService scheduler;

    @Override
    public boolean isValid(String data, String schemaId) {
        Set validationMessages;
        JsonSchema jsonSchema;
        JsonNode jsonNode;
        try {
            jsonNode = this.objectMapper.readTree(data);
            jsonSchema = this.jsonSchemaFactory.getSchema(new URI(schemaId));
        }
        catch (Exception e) {
            logger.debug("Schema validation failed", (Throwable)e);
            return false;
        }
        if (jsonNode == null) {
            logger.debug("Schema validation failed because: no data to validate");
            return false;
        }
        if (jsonSchema == null) {
            logger.debug("Schema validation failed because: Schema not found {}", (Object)schemaId);
            return false;
        }
        try {
            validationMessages = jsonSchema.validate(jsonNode);
        }
        catch (Exception e) {
            logger.debug("Schema validation failed", (Throwable)e);
            return false;
        }
        if (validationMessages == null || validationMessages.isEmpty()) {
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Schema validation found {} errors while validating against schema: {}", (Object)validationMessages.size(), (Object)schemaId);
            for (ValidationMessage validationMessage : validationMessages) {
                logger.debug("Validation error: {}", (Object)validationMessage);
            }
        }
        return false;
    }

    @Override
    public boolean isEventValid(String event, String eventType) {
        JsonSchemaWrapper eventSchema = this.getSchemaForEventType(eventType);
        if (eventSchema != null) {
            return this.isValid(event, eventSchema.getItemId());
        }
        return false;
    }

    @Override
    public JsonSchemaWrapper getSchema(String schemaId) {
        return (JsonSchemaWrapper)((Object)this.schemasById.get(schemaId));
    }

    @Override
    public Set<String> getInstalledJsonSchemaIds() {
        return this.schemasById.keySet();
    }

    @Override
    public List<JsonSchemaWrapper> getSchemasByTarget(String target) {
        return this.schemasById.values().stream().filter(jsonSchemaWrapper -> jsonSchemaWrapper.getTarget() != null && jsonSchemaWrapper.getTarget().equals(target)).collect(Collectors.toList());
    }

    @Override
    public JsonSchemaWrapper getSchemaForEventType(String eventType) {
        if (StringUtils.isEmpty((CharSequence)eventType)) {
            return null;
        }
        return this.schemasById.values().stream().filter(jsonSchemaWrapper -> jsonSchemaWrapper.getTarget() != null && jsonSchemaWrapper.getTarget().equals(TARGET_EVENTS) && jsonSchemaWrapper.getName() != null && jsonSchemaWrapper.getName().equals(eventType)).findFirst().orElse(null);
    }

    @Override
    public void saveSchema(String schema) {
        JsonSchemaWrapper jsonSchemaWrapper = this.buildJsonSchemaWrapper(schema);
        if (this.predefinedUnomiJSONSchemaById.containsKey(jsonSchemaWrapper.getItemId())) {
            throw new IllegalArgumentException("Trying to save a Json Schema that is using the ID of an existing Json Schema provided by Unomi is forbidden");
        }
        this.persistenceService.save((Item)jsonSchemaWrapper);
    }

    @Override
    public boolean deleteSchema(String schemaId) {
        if (!this.predefinedUnomiJSONSchemaById.containsKey(schemaId)) {
            return this.persistenceService.remove(schemaId, JsonSchemaWrapper.class);
        }
        return false;
    }

    @Override
    public void loadPredefinedSchema(InputStream schemaStream) throws IOException {
        String schema = IOUtils.toString((InputStream)schemaStream);
        JsonSchemaWrapper jsonSchemaWrapper = this.buildJsonSchemaWrapper(schema);
        this.predefinedUnomiJSONSchemaById.put(jsonSchemaWrapper.getItemId(), jsonSchemaWrapper);
    }

    @Override
    public boolean unloadPredefinedSchema(InputStream schemaStream) {
        JsonNode schemaNode = this.jsonSchemaFactory.getSchema(schemaStream).getSchemaNode();
        String schemaId = schemaNode.get("$id").asText();
        return this.predefinedUnomiJSONSchemaById.remove(schemaId) != null;
    }

    private JsonSchemaWrapper buildJsonSchemaWrapper(String schema) {
        JsonSchema jsonSchema = this.jsonSchemaFactory.getSchema(schema);
        JsonNode schemaNode = jsonSchema.getSchemaNode();
        String schemaId = schemaNode.get("$id").asText();
        String target = schemaNode.at("/self/target").asText();
        String name = schemaNode.at("/self/name").asText();
        String extendsSchemaId = schemaNode.at("/self/extends").asText();
        if (TARGET_EVENTS.equals(target) && !name.matches("[_A-Za-z][_0-9A-Za-z]*")) {
            throw new IllegalArgumentException("The \"/self/name\" value should match the following regular expression [_A-Za-z][_0-9A-Za-z]* for the Json schema on events");
        }
        return new JsonSchemaWrapper(schemaId, schema, target, name, extendsSchemaId, new Date());
    }

    private void refreshJSONSchemas() {
        boolean changes;
        HashMap<String, JsonSchemaWrapper> schemasByIdReloaded = new HashMap<String, JsonSchemaWrapper>();
        schemasByIdReloaded.putAll(this.predefinedUnomiJSONSchemaById);
        schemasByIdReloaded.putAll(this.persistenceService.getAllItems(JsonSchemaWrapper.class).stream().collect(Collectors.toMap(Item::getItemId, s -> s)));
        boolean bl = changes = schemasByIdReloaded.size() != this.schemasById.size();
        if (!changes) {
            for (JsonSchemaWrapper reloadedSchema : schemasByIdReloaded.values()) {
                JsonSchemaWrapper oldSchema = (JsonSchemaWrapper)((Object)this.schemasById.get(reloadedSchema.getItemId()));
                if (oldSchema != null && oldSchema.getTimeStamp().equals(reloadedSchema.getTimeStamp())) continue;
                changes = true;
                break;
            }
        }
        if (changes) {
            this.schemasById = new ConcurrentHashMap<String, JsonSchemaWrapper>(schemasByIdReloaded);
            this.initExtensions(schemasByIdReloaded);
            this.initJsonSchemaFactory();
        }
    }

    private void initExtensions(Map<String, JsonSchemaWrapper> schemas) {
        HashMap extensionsReloaded = new HashMap();
        List schemaExtensions = schemas.values().stream().filter(jsonSchemaWrapper -> StringUtils.isNotBlank((CharSequence)jsonSchemaWrapper.getExtendsSchemaId())).collect(Collectors.toList());
        for (JsonSchemaWrapper extension : schemaExtensions) {
            String extendedSchemaId = extension.getExtendsSchemaId();
            if (!extension.getItemId().equals(extendedSchemaId)) {
                if (!extensionsReloaded.containsKey(extendedSchemaId)) {
                    extensionsReloaded.put(extendedSchemaId, new HashSet());
                }
                ((Set)extensionsReloaded.get(extendedSchemaId)).add(extension.getItemId());
                continue;
            }
            logger.warn("A schema cannot extends himself, please fix your schema definition for schema: {}", (Object)extendedSchemaId);
        }
        this.extensions = new ConcurrentHashMap<String, Set<String>>(extensionsReloaded);
    }

    private String generateExtendedSchema(String id, String schema) throws JsonProcessingException {
        Set extensionIds = (Set)this.extensions.get(id);
        if (extensionIds != null && extensionIds.size() > 0) {
            ArrayNode allOf;
            ObjectNode jsonSchema = (ObjectNode)this.objectMapper.readTree(schema);
            if (jsonSchema.at("/allOf") instanceof MissingNode) {
                allOf = this.objectMapper.createArrayNode();
            } else if (jsonSchema.at("/allOf") instanceof ArrayNode) {
                allOf = (ArrayNode)jsonSchema.at("/allOf");
            } else {
                logger.warn("Cannot extends schema allOf property, it should be an Array, please fix your schema definition for schema: {}", (Object)id);
                return schema;
            }
            for (String extensionId : extensionIds) {
                ObjectNode newAllOf = this.objectMapper.createObjectNode();
                newAllOf.put("$ref", extensionId);
                allOf.add((JsonNode)newAllOf);
            }
            jsonSchema.putArray("allOf").addAll(allOf);
            return this.objectMapper.writeValueAsString((Object)jsonSchema);
        }
        return schema;
    }

    private void initPersistenceIndex() {
        if (this.persistenceService.createIndex("jsonSchema")) {
            logger.info("{} index created", (Object)"jsonSchema");
        } else {
            logger.info("{} index already exists", (Object)"jsonSchema");
        }
    }

    private void initTimers() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    SchemaServiceImpl.this.refreshJSONSchemas();
                }
                catch (Exception e) {
                    logger.error("Error while refreshing JSON Schemas", (Throwable)e);
                }
            }
        };
        this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(task, 0L, this.jsonSchemaRefreshInterval.intValue(), TimeUnit.MILLISECONDS);
    }

    private void initJsonSchemaFactory() {
        this.jsonSchemaFactory = JsonSchemaFactory.builder((JsonSchemaFactory)JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V201909)).addMetaSchema(JsonMetaSchema.builder((String)URI, (JsonMetaSchema)JsonMetaSchema.getV201909()).addKeyword((Keyword)new ScopeKeyword(this.scopeService)).addKeyword((Keyword)new NonValidationKeyword("self")).build()).defaultMetaSchemaURI(URI).uriFetcher(uri -> {
            logger.debug("Fetching schema {}", (Object)uri);
            String schemaId = uri.toString();
            JsonSchemaWrapper jsonSchemaWrapper = this.getSchema(schemaId);
            if (jsonSchemaWrapper == null) {
                logger.error("Couldn't find schema {}", (Object)uri);
                return null;
            }
            String schema = jsonSchemaWrapper.getSchema();
            schema = this.generateExtendedSchema(schemaId, schema);
            return IOUtils.toInputStream((String)schema);
        }, new String[]{"https", "http"}).build();
    }

    public void init() {
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.initPersistenceIndex();
        this.initJsonSchemaFactory();
        this.initTimers();
        logger.info("Schema service initialized.");
    }

    public void destroy() {
        this.scheduledFuture.cancel(true);
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        logger.info("Schema service shutdown.");
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setScopeService(ScopeService scopeService) {
        this.scopeService = scopeService;
    }

    public void setJsonSchemaRefreshInterval(Integer jsonSchemaRefreshInterval) {
        this.jsonSchemaRefreshInterval = jsonSchemaRefreshInterval;
    }
}

