/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http.util;

import groovyx.net.http.TransportingException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IoUtils {
    public static byte[] streamToBytes(InputStream inputStream) throws IOException {
        return IoUtils.streamToBytes(inputStream, true);
    }

    /*
     * Loose catch block
     */
    public static byte[] streamToBytes(InputStream inputStream, boolean close) throws IOException {
        try {
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                int read;
                byte[] bytes = new byte[2048];
                while ((read = inputStream.read(bytes)) != -1) {
                    outputStream.write(bytes, 0, read);
                }
                byte[] byArray = outputStream.toByteArray();
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (close) {
                inputStream.close();
            }
        }
    }

    public static String copyAsString(BufferedInputStream inputStream) throws IOException, IllegalStateException {
        if (inputStream == null) {
            return null;
        }
        try {
            inputStream.mark(Integer.MAX_VALUE);
            String string = new String(IoUtils.streamToBytes(inputStream, false));
            return string;
        }
        finally {
            try {
                inputStream.reset();
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Unable to reset stream - original stream content may be corrupted");
            }
        }
    }

    public static void transfer(InputStream istream, OutputStream ostream, boolean close) {
        try {
            int read;
            byte[] bytes = new byte[2048];
            while ((read = istream.read(bytes)) != -1) {
                ostream.write(bytes, 0, read);
            }
        }
        catch (IOException e) {
            throw new TransportingException(e);
        }
        finally {
            if (close) {
                try {
                    ostream.close();
                }
                catch (IOException ioe) {
                    throw new TransportingException(ioe);
                }
            }
        }
    }
}

