/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.utils.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.utils.resource.CapabilitySet;
import org.apache.felix.utils.resource.RequirementImpl;
import org.apache.felix.utils.resource.SimpleFilter;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.repository.Repository;

public class BaseRepository
implements Repository {
    protected final List<Resource> resources = new ArrayList<Resource>();
    protected final Map<String, CapabilitySet> capSets = new HashMap<String, CapabilitySet>();

    public BaseRepository() {
    }

    public BaseRepository(Collection<Resource> resources) {
        this();
        for (Resource resource : resources) {
            this.addResource(resource);
        }
    }

    protected void addResource(Resource resource) {
        for (Capability cap : resource.getCapabilities(null)) {
            String ns = cap.getNamespace();
            CapabilitySet cs = this.capSets.get(ns);
            if (cs == null) {
                cs = new CapabilitySet(Collections.singletonList(ns));
                this.capSets.put(ns, cs);
            }
            cs.addCapability(cap);
        }
        this.resources.add(resource);
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        HashMap<Requirement, Collection<Capability>> result = new HashMap<Requirement, Collection<Capability>>();
        for (Requirement requirement : requirements) {
            CapabilitySet set = this.capSets.get(requirement.getNamespace());
            if (set != null) {
                String filter;
                SimpleFilter sf = requirement instanceof RequirementImpl ? ((RequirementImpl)requirement).getFilter() : ((filter = (String)requirement.getDirectives().get("filter")) != null ? SimpleFilter.parse(filter) : SimpleFilter.MATCH_ALL_FILTER);
                result.put(requirement, set.match(sf, true));
                continue;
            }
            result.put(requirement, Collections.emptyList());
        }
        return result;
    }
}

