/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.api;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.unomi.api.ConsentStatus;

public class Consent
implements Serializable {
    private String scope;
    private String typeIdentifier;
    private ConsentStatus status;
    private Date statusDate;
    private Date revokeDate;

    public Consent() {
    }

    public Consent(String scope, String typeIdentifier, ConsentStatus status, Date statusDate, Date revokeDate) {
        this.scope = scope;
        this.typeIdentifier = typeIdentifier;
        this.status = status;
        this.statusDate = statusDate;
        this.revokeDate = revokeDate;
    }

    public Consent(Map<String, Object> consentMap, DateFormat dateFormat) throws ParseException {
        String revokeDateStr;
        String statusDateStr;
        if (consentMap.containsKey("scope")) {
            this.setScope((String)consentMap.get("scope"));
        }
        if (consentMap.containsKey("typeIdentifier")) {
            this.setTypeIdentifier((String)consentMap.get("typeIdentifier"));
        }
        if (consentMap.containsKey("status")) {
            String consentStatus = (String)consentMap.get("status");
            this.setStatus(ConsentStatus.valueOf(consentStatus));
        }
        if (consentMap.containsKey("statusDate") && (statusDateStr = (String)consentMap.get("statusDate")) != null && statusDateStr.trim().length() > 0) {
            this.setStatusDate(dateFormat.parse(statusDateStr));
        }
        if (consentMap.containsKey("revokeDate") && (revokeDateStr = (String)consentMap.get("revokeDate")) != null && revokeDateStr.trim().length() > 0) {
            this.setRevokeDate(dateFormat.parse(revokeDateStr));
        }
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setTypeIdentifier(String typeIdentifier) {
        this.typeIdentifier = typeIdentifier;
    }

    public String getTypeIdentifier() {
        return this.typeIdentifier;
    }

    public ConsentStatus getStatus() {
        return this.status;
    }

    public void setStatus(ConsentStatus status) {
        this.status = status;
    }

    public Date getStatusDate() {
        return this.statusDate;
    }

    public void setStatusDate(Date statusDate) {
        this.statusDate = statusDate;
    }

    public Date getRevokeDate() {
        return this.revokeDate;
    }

    public void setRevokeDate(Date revokeDate) {
        this.revokeDate = revokeDate;
    }

    @XmlTransient
    public boolean isConsentGrantedNow() {
        return this.isConsentGrantedAtDate(new Date());
    }

    @XmlTransient
    public boolean isConsentGrantedAtDate(Date testDate) {
        return this.getStatusDate().before(testDate) && (this.getRevokeDate() == null || this.getRevokeDate().after(testDate)) && this.getStatus().equals((Object)ConsentStatus.GRANTED);
    }

    @XmlTransient
    public Map<String, Object> toMap(DateFormat dateFormat) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("scope", this.scope);
        map.put("typeIdentifier", this.typeIdentifier);
        map.put("status", this.status.toString());
        if (this.statusDate != null) {
            map.put("statusDate", dateFormat.format(this.statusDate));
        }
        if (this.revokeDate != null) {
            map.put("revokeDate", dateFormat.format(this.revokeDate));
        }
        return map;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Consent{");
        sb.append("scope='").append(this.scope).append('\'');
        sb.append(", typeIdentifier='").append(this.typeIdentifier).append('\'');
        sb.append(", status=").append((Object)this.status);
        sb.append(", statusDate=").append(this.statusDate);
        sb.append(", revokeDate=").append(this.revokeDate);
        sb.append('}');
        return sb.toString();
    }
}

