/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.openapi;

import java.util.Objects;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.cxf.jaxrs.common.openapi.DelegatingServletConfig;
import org.apache.cxf.jaxrs.common.openapi.SyntheticServletConfig;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.message.Message;

class ServletConfigProvider
implements ContextProvider<ServletConfig> {
    private final String contextId;

    ServletConfigProvider(String contextId) {
        this.contextId = contextId;
    }

    public ServletConfig createContext(Message message) {
        ServletConfig sc = (ServletConfig)message.get((Object)"HTTP.CONFIG");
        if (sc == null) {
            ServletContext context = (ServletContext)message.get((Object)"HTTP.CONTEXT");
            if (context != null) {
                return new SyntheticServletConfig(context){

                    public String getInitParameter(String name) {
                        if (Objects.equals("openapi.context.id", name)) {
                            return ServletConfigProvider.this.contextId;
                        }
                        return super.getInitParameter(name);
                    }
                };
            }
        } else {
            return new DelegatingServletConfig(sc){

                public String getInitParameter(String name) {
                    if (Objects.equals("openapi.context.id", name)) {
                        return ServletConfigProvider.this.contextId;
                    }
                    return super.getInitParameter(name);
                }
            };
        }
        return sc;
    }
}

