/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.commands;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.unomi.api.conditions.ConditionType;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.persistence.spi.CustomObjectMapper;

@Command(scope="unomi", name="condition-view", description="This will display a single condition deployed in the Apache Unomi Context Server")
@Service
public class ConditionView
implements Action {
    @Reference
    DefinitionsService definitionsService;
    @Argument(index=0, name="conditionId", description="The identifier for the condition", required=true, multiValued=false)
    String conditionTypeIdentifier;

    public Object execute() throws Exception {
        ConditionType conditionType = this.definitionsService.getConditionType(this.conditionTypeIdentifier);
        if (conditionType == null) {
            System.out.println("Couldn't find an action with id=" + this.conditionTypeIdentifier);
            return null;
        }
        String jsonRule = CustomObjectMapper.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)conditionType);
        System.out.println(jsonRule);
        return null;
    }
}

