/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.parsing;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.blueprint.Interceptor;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.PassThroughMetadata;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutablePassThroughMetadata;
import org.apache.aries.transaction.BundleWideTxData;
import org.apache.aries.transaction.Constants;
import org.apache.aries.transaction.TxComponentMetaDataHelper;
import org.apache.aries.transaction.annotations.TransactionPropagationType;
import org.apache.aries.transaction.parsing.AnnotationParser;
import org.osgi.framework.Bundle;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TxNamespaceHandler
implements NamespaceHandler {
    public static final String ANNOTATION_PARSER_BEAN_NAME = ".org_apache_aries_transaction_annotations";
    private static final String BEAN = "bean";
    private static final String VALUE = "value";
    private static final String METHOD = "method";
    public static final String DEFAULT_INTERCEPTOR_ID = "txinterceptor";
    private static final String INTERCEPTOR_BLUEPRINT_ID = "interceptor.blueprint.id";
    private static final Logger LOGGER = LoggerFactory.getLogger(TxNamespaceHandler.class);
    private TxComponentMetaDataHelper metaDataHelper;
    private Interceptor interceptor = null;
    private final ConcurrentMap<ComponentDefinitionRegistry, Bundle> registered = new ConcurrentHashMap<ComponentDefinitionRegistry, Bundle>();
    private final Map<String, String> schemaMap = new HashMap<String, String>();

    public TxNamespaceHandler() {
        this.schemaMap.put("http://aries.apache.org/xmlns/transactions/v1.0.0", "transactionv10.xsd");
        this.schemaMap.put("http://aries.apache.org/xmlns/transactions/v1.1.0", "transactionv11.xsd");
        this.schemaMap.put("http://aries.apache.org/xmlns/transactions/v1.2.0", "transactionv12.xsd");
    }

    private void parseElement(Element elt, ComponentMetadata cm, ParserContext pc) {
        Node n;
        LOGGER.debug("parser asked to parse element {} ", (Object)elt);
        ComponentDefinitionRegistry cdr = pc.getComponentDefinitionRegistry();
        if ("transaction".equals(elt.getLocalName())) {
            Bundle blueprintBundle = this.getBlueprintBundle(cdr);
            if (blueprintBundle != null) {
                this.registered.put(cdr, blueprintBundle);
                TransactionPropagationType txType = this.getType(elt.getAttribute(VALUE));
                String method = elt.getAttribute(METHOD);
                String beanAttr = elt.getAttribute(BEAN);
                if (cm == null) {
                    this.registerComponentsWithInterceptor(cdr, beanAttr);
                    this.metaDataHelper.populateBundleWideTransactionData(cdr, txType, method, beanAttr);
                } else {
                    cdr.registerInterceptorWithComponent(cm, this.interceptor);
                    this.metaDataHelper.setComponentTransactionData(cdr, cm, txType, method);
                }
            }
        } else if ("enable-annotations".equals(elt.getLocalName()) && ((n = elt.getChildNodes().item(0)) == null || Boolean.parseBoolean(n.getNodeValue())) && !cdr.containsComponentDefinition(ANNOTATION_PARSER_BEAN_NAME)) {
            LOGGER.debug("Enabling annotation based transactions");
            MutableBeanMetadata meta = this.createAnnotationParserBean(pc, cdr);
            cdr.registerComponentDefinition((ComponentMetadata)meta);
        }
    }

    private Bundle getBlueprintBundle(ComponentDefinitionRegistry cdr) {
        ComponentMetadata meta = cdr.getComponentDefinition("blueprintBundle");
        Bundle blueprintBundle = null;
        if (meta instanceof PassThroughMetadata) {
            blueprintBundle = (Bundle)((PassThroughMetadata)meta).getObject();
        }
        return blueprintBundle;
    }

    private MutableBeanMetadata createAnnotationParserBean(ParserContext pc, ComponentDefinitionRegistry cdr) {
        MutableBeanMetadata meta = (MutableBeanMetadata)pc.createMetadata(MutableBeanMetadata.class);
        meta.setId(ANNOTATION_PARSER_BEAN_NAME);
        meta.setRuntimeClass(AnnotationParser.class);
        meta.setProcessor(true);
        MutablePassThroughMetadata cdrMeta = (MutablePassThroughMetadata)pc.createMetadata(MutablePassThroughMetadata.class);
        cdrMeta.setObject((Object)cdr);
        meta.addArgument((Metadata)cdrMeta, ComponentDefinitionRegistry.class.getName(), 0);
        MutablePassThroughMetadata interceptorMeta = (MutablePassThroughMetadata)pc.createMetadata(MutablePassThroughMetadata.class);
        interceptorMeta.setObject((Object)this.interceptor);
        meta.addArgument((Metadata)interceptorMeta, Interceptor.class.getName(), 1);
        MutablePassThroughMetadata helperMeta = (MutablePassThroughMetadata)pc.createMetadata(MutablePassThroughMetadata.class);
        helperMeta.setObject((Object)this.metaDataHelper);
        meta.addArgument((Metadata)helperMeta, TxComponentMetaDataHelper.class.getName(), 2);
        return meta;
    }

    private TransactionPropagationType getType(String typeSt) {
        return typeSt == null || typeSt.length() == 0 ? null : TransactionPropagationType.valueOf(typeSt);
    }

    public ComponentMetadata decorate(Node node, ComponentMetadata cm, ParserContext pc) {
        if (node instanceof Element) {
            Element elt = (Element)node;
            this.parseElement(elt, cm, pc);
        }
        return cm;
    }

    public Metadata parse(Element elt, ParserContext pc) {
        this.parseElement(elt, pc.getEnclosingComponent(), pc);
        return null;
    }

    public URL getSchemaLocation(String namespaceUri) {
        String xsdPath = this.schemaMap.get(namespaceUri);
        return xsdPath != null ? this.getClass().getResource(xsdPath) : null;
    }

    public final void setTxMetaDataHelper(TxComponentMetaDataHelper transactionEnhancer) {
        this.metaDataHelper = transactionEnhancer;
    }

    public final void setBlueprintContainer(BlueprintContainer container) {
        String id = this.getTxInterceptorId();
        this.interceptor = (Interceptor)container.getComponentInstance(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTxInterceptorId() {
        String id = DEFAULT_INTERCEPTOR_ID;
        InputStream is = TxNamespaceHandler.class.getResourceAsStream("/provider.properties");
        if (is == null) {
            return id;
        }
        try {
            Properties props = new Properties();
            props.load(is);
            if (props.containsKey(INTERCEPTOR_BLUEPRINT_ID)) {
                id = props.getProperty(INTERCEPTOR_BLUEPRINT_ID);
            }
        }
        catch (IOException e) {
            LOGGER.error(Constants.MESSAGES.getMessage("unable.to.load.provider.props", new Object[0]), (Throwable)e);
        }
        finally {
            this.safeClose(is);
        }
        return id;
    }

    public Set<Class> getManagedClasses() {
        return null;
    }

    public boolean isRegistered(ComponentDefinitionRegistry cdr) {
        return this.registered.containsKey(cdr);
    }

    public void unregister(Bundle blueprintBundle) {
        Iterator it = this.registered.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            if (!blueprintBundle.equals(e.getValue())) continue;
            this.metaDataHelper.unregister((ComponentDefinitionRegistry)e.getKey());
            it.remove();
        }
    }

    private void registerComponentsWithInterceptor(ComponentDefinitionRegistry cdr, String bean) {
        Set ids = cdr.getComponentDefinitionNames();
        if (bean == null || bean.length() == 0) {
            for (String id : ids) {
                ComponentMetadata componentMetadata = cdr.getComponentDefinition(id);
                cdr.registerInterceptorWithComponent(componentMetadata, this.interceptor);
            }
        } else {
            BundleWideTxData data = new BundleWideTxData(null, "*", bean);
            for (Pattern p : data.getBean()) {
                for (String id : ids) {
                    Matcher m = p.matcher(id);
                    if (!m.matches()) continue;
                    ComponentMetadata componentMetadata = cdr.getComponentDefinition(id);
                    cdr.registerInterceptorWithComponent(componentMetadata, this.interceptor);
                }
            }
        }
    }

    private void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

