/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.web.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.karaf.web.WebBundle;
import org.apache.karaf.web.WebContainerService;
import org.apache.karaf.web.internal.WebEventHandler;
import org.ops4j.pax.web.service.spi.WarManager;
import org.ops4j.pax.web.service.spi.WebEvent;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebContainerServiceImpl
implements WebContainerService,
BundleListener {
    private BundleContext bundleContext;
    private WebEventHandler webEventHandler;
    private WarManager warManager;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebContainerServiceImpl.class);

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setWebEventHandler(WebEventHandler webEventHandler) {
        this.webEventHandler = webEventHandler;
    }

    public void setWarManager(WarManager warManager) {
        this.warManager = warManager;
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        if (bundleEvent.getType() == 16 || bundleEvent.getType() == 64 || bundleEvent.getType() == 4) {
            this.webEventHandler.getBundleEvents().remove(bundleEvent.getBundle().getBundleId());
        }
    }

    @Override
    public List<WebBundle> list() throws Exception {
        Bundle[] bundles = this.bundleContext.getBundles();
        Map<Long, WebEvent> bundleEvents = this.webEventHandler.getBundleEvents();
        ArrayList<WebBundle> webBundles = new ArrayList<WebBundle>();
        if (bundles != null) {
            for (Bundle bundle : bundles) {
                String contextPath = (String)bundle.getHeaders().get("Web-ContextPath");
                if (contextPath == null) {
                    contextPath = (String)bundle.getHeaders().get("Webapp-Context");
                }
                if (contextPath == null) continue;
                WebBundle webBundle = new WebBundle();
                contextPath = contextPath.trim();
                String name = (String)bundle.getHeaders().get("Bundle-Name");
                name = name == null ? bundle.getSymbolicName() : name;
                name = name == null ? bundle.getLocation() : name;
                String version = (String)bundle.getHeaders().get("Bundle-Version");
                name = version != null ? name + " (" + version + ")" : name;
                long bundleId = bundle.getBundleId();
                int level = ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).getStartLevel();
                if (!contextPath.startsWith("/")) {
                    contextPath = "/" + contextPath;
                }
                webBundle.setBundleId(bundleId);
                webBundle.setName(name);
                webBundle.setContextPath(contextPath);
                webBundle.setLevel(level);
                webBundle.setState(this.getStateString(bundle));
                webBundle.setWebState(this.state(bundle.getBundleId()));
                webBundles.add(webBundle);
            }
        }
        return webBundles;
    }

    @Override
    public void install(String location, String contextPath) throws Exception {
        String completeLocation = "webbundle:" + location + "?Web-ContextPath=" + contextPath;
        Bundle bundle = this.bundleContext.installBundle(completeLocation);
        bundle.start();
    }

    @Override
    public void uninstall(List<Long> bundleIds) throws Exception {
        if (bundleIds != null && !bundleIds.isEmpty()) {
            for (long bundleId : bundleIds) {
                if (!this.webEventHandler.getBundleEvents().containsKey(bundleId)) continue;
                WebEvent webEvent = this.webEventHandler.getBundleEvents().get(bundleId);
                Bundle bundle = webEvent.getBundle();
                if (bundle != null) {
                    bundle.uninstall();
                    continue;
                }
                System.out.println("Bundle ID " + bundleId + " is invalid");
                LOGGER.warn("Bundle ID {} is invalid", (Object)bundleId);
            }
        }
    }

    @Override
    public void start(List<Long> bundleIds) throws Exception {
        if (bundleIds != null && !bundleIds.isEmpty()) {
            for (long bundleId : bundleIds) {
                if (!this.webEventHandler.getBundleEvents().containsKey(bundleId)) continue;
                WebEvent webEvent = this.webEventHandler.getBundleEvents().get(bundleId);
                Bundle bundle = webEvent.getBundle();
                if (bundle != null) {
                    this.warManager.start(bundleId, null);
                    continue;
                }
                System.out.println("Bundle ID " + bundleId + " is invalid");
                LOGGER.warn("Bundle ID {} is invalid", (Object)bundleId);
            }
        }
    }

    @Override
    public void stop(List<Long> bundleIds) throws Exception {
        if (bundleIds != null && !bundleIds.isEmpty()) {
            for (long bundleId : bundleIds) {
                if (!this.webEventHandler.getBundleEvents().containsKey(bundleId)) continue;
                WebEvent webEvent = this.webEventHandler.getBundleEvents().get(bundleId);
                Bundle bundle = webEvent.getBundle();
                if (bundle != null) {
                    this.warManager.stop(bundleId);
                    continue;
                }
                System.out.println("Bundle ID " + bundleId + " is invalid");
                LOGGER.warn("Bundle ID {} is invalid", (Object)bundleId);
            }
        }
    }

    @Override
    public String state(long bundleId) {
        Map<Long, WebEvent> bundleEvents = this.webEventHandler.getBundleEvents();
        String topic = "Unknown    ";
        if (bundleEvents.containsKey(bundleId)) {
            WebEvent webEvent = bundleEvents.get(bundleId);
            switch (webEvent.getType()) {
                case 1: {
                    topic = "Deploying  ";
                    break;
                }
                case 2: {
                    topic = "Deployed   ";
                    break;
                }
                case 3: {
                    topic = "Undeploying";
                    break;
                }
                case 4: {
                    topic = "Undeployed ";
                    break;
                }
                case 5: {
                    topic = "Failed     ";
                    break;
                }
                case 6: {
                    topic = "Waiting    ";
                    break;
                }
                default: {
                    topic = "Failed     ";
                }
            }
        }
        while (topic.length() < 11) {
            topic = topic + " ";
        }
        return topic;
    }

    private String getStateString(Bundle bundle) {
        int state = bundle.getState();
        if (state == 32) {
            return "Active     ";
        }
        if (state == 2) {
            return "Installed  ";
        }
        if (state == 4) {
            return "Resolved   ";
        }
        if (state == 8) {
            return "Starting   ";
        }
        if (state == 16) {
            return "Stopping   ";
        }
        return "Unknown    ";
    }

    @Override
    public String getWebContextPath(Long id) {
        Map<Long, WebEvent> bundleEvents = this.webEventHandler.getBundleEvents();
        WebEvent webEvent = bundleEvents.get(id);
        return webEvent.getContextPath();
    }
}

