/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features;

import java.net.MalformedURLException;
import java.util.regex.Pattern;
import org.apache.felix.utils.version.VersionCleaner;
import org.apache.felix.utils.version.VersionRange;
import org.apache.karaf.util.maven.Parser;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationPattern {
    public static Logger LOG = LoggerFactory.getLogger(LocationPattern.class);
    private String originalUri;
    private Pattern originalPattern;
    private String groupId;
    private Pattern groupIdPattern;
    private String artifactId;
    private Pattern artifactIdPattern;
    private String versionString;
    private Version version;
    private VersionRange versionRange;
    private String type;
    private Pattern typePattern;
    private String classifier;
    private Pattern classifierPattern;

    public LocationPattern(String uri) throws IllegalArgumentException {
        if (uri == null) {
            throw new IllegalArgumentException("URI to match should not be null");
        }
        this.originalUri = uri;
        if (!this.originalUri.startsWith("mvn:")) {
            this.originalPattern = LocationPattern.toRegExp(this.originalUri);
        } else {
            uri = uri.substring(4);
            Parser parser = null;
            try {
                parser = new Parser(uri);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            if ("LATEST".equals(parser.getVersion())) {
                parser.setVersion(null);
            }
            this.groupId = parser.getGroup();
            if (this.groupId.contains("*")) {
                this.groupIdPattern = LocationPattern.toRegExp(this.groupId);
            }
            this.artifactId = parser.getArtifact();
            if (this.artifactId.contains("*")) {
                this.artifactIdPattern = LocationPattern.toRegExp(this.artifactId);
            }
            this.versionString = parser.getVersion();
            if (this.versionString != null && this.versionString.length() >= 1) {
                try {
                    char first = this.versionString.charAt(0);
                    if (first == '[' || first == '(') {
                        this.versionRange = new VersionRange(this.versionString, true, false);
                    } else {
                        this.version = new Version(VersionCleaner.clean(this.versionString));
                    }
                }
                catch (IllegalArgumentException e) {
                    IllegalArgumentException mue = new IllegalArgumentException("Can't parse version \"" + this.versionString + "\" as OSGi version object.", e);
                    throw mue;
                }
            }
            this.type = parser.getType();
            if (this.type != null && this.type.contains("*")) {
                this.typePattern = LocationPattern.toRegExp(this.type);
            }
            this.classifier = parser.getClassifier();
            if (this.classifier != null && this.classifier.contains("*")) {
                this.classifierPattern = LocationPattern.toRegExp(this.classifier);
            }
        }
    }

    public String getOriginalUri() {
        return this.originalUri;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public static Pattern toRegExp(String value) {
        return Pattern.compile(value.replaceAll("\\.", "\\\\\\.").replaceAll("\\$", "\\\\\\$").replaceAll("\\^", "\\\\\\^").replaceAll("\\*", ".*"));
    }

    public boolean matches(String otherUri) {
        LocationPattern other;
        if (otherUri == null) {
            return false;
        }
        if (this.originalPattern != null) {
            return this.originalPattern.matcher(otherUri).matches();
        }
        try {
            other = new LocationPattern(otherUri);
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Can't parse \"" + otherUri + "\" as Maven URI. Ignoring.");
            return false;
        }
        if (other.originalPattern != null) {
            return false;
        }
        if (other.versionRange != null) {
            LOG.warn("Matched URI can't use version ranges: " + otherUri);
            return false;
        }
        boolean match = this.groupIdPattern == null ? this.groupId.equals(other.groupId) : this.groupIdPattern.matcher(other.groupId).matches();
        if (!match) {
            return false;
        }
        match = this.artifactIdPattern == null ? this.artifactId.equals(other.artifactId) : this.artifactIdPattern.matcher(other.artifactId).matches();
        if (!match) {
            return false;
        }
        if (this.versionRange != null && other.version != null) {
            match = this.versionRange.contains(other.version);
        } else {
            boolean bl = match = this.version == null || this.version.equals((Object)other.version);
        }
        if (!match) {
            return false;
        }
        if (this.typePattern != null) {
            match = this.typePattern.matcher(other.type == null ? "jar" : other.type).matches();
        } else {
            boolean bl = match = this.versionString == null || this.type.equals(other.type);
        }
        if (!match) {
            return false;
        }
        match = this.classifierPattern != null ? this.classifierPattern.matcher(other.classifier == null ? "" : other.classifier).matches() : (this.classifier != null ? this.classifier.equals(other.classifier) : other.classifierPattern == null);
        return match;
    }

    public boolean strictlyMatches(String otherUri) {
        boolean match = this.matches(otherUri);
        if (!match) {
            return false;
        }
        LocationPattern other = null;
        try {
            other = new LocationPattern(otherUri);
        }
        catch (IllegalArgumentException ignored) {
            return true;
        }
        if (this.classifierPattern == null && this.classifier == null) {
            match = other.classifierPattern == null && other.classifier == null;
        }
        return match;
    }

    public String toString() {
        return this.originalUri;
    }
}

