/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.finder.archive;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.filter.Filter;

public class FilteredArchive
implements Archive {
    private final Archive archive;
    private final Filter filter;

    public FilteredArchive(Archive archive, Filter filter) {
        this.archive = archive;
        this.filter = filter;
    }

    @Override
    public InputStream getBytecode(String className) throws IOException, ClassNotFoundException {
        return this.archive.getBytecode(className);
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.archive.loadClass(className);
    }

    @Override
    public Iterator<Archive.Entry> iterator() {
        return new FilteredIterator(this.archive.iterator());
    }

    private final class FilteredIterator
    implements Iterator<Archive.Entry> {
        private final Iterator<Archive.Entry> it;
        private Archive.Entry next;

        private FilteredIterator(Iterator<Archive.Entry> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (!this.it.hasNext()) {
                return false;
            }
            this.seek();
            return this.hasNext();
        }

        @Override
        public Archive.Entry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Archive.Entry s = this.next;
            this.next = null;
            return s;
        }

        @Override
        public void remove() {
            this.it.remove();
        }

        private void seek() {
            while (this.next == null && this.it.hasNext()) {
                this.next = this.it.next();
                if (FilteredArchive.this.filter.accept(this.next.getName())) {
                    return;
                }
                this.next = null;
            }
        }
    }
}

