/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.shell;

import java.util.Set;
import org.apache.karaf.cellar.core.Node;
import org.apache.karaf.cellar.shell.ClusterCommandSupport;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="cluster", name="node-list", description="List the nodes in the cluster")
@Service
public class NodesListCommand
extends ClusterCommandSupport {
    protected Object doExecute() throws Exception {
        Set nodes = this.clusterManager.listNodes();
        if (nodes != null && !nodes.isEmpty()) {
            ShellTable table = new ShellTable();
            table.column(" ");
            table.column("Id");
            table.column("Alias");
            table.column("Host Name");
            table.column("Port");
            for (Node node : nodes) {
                String local = "";
                if (node.equals(this.clusterManager.getNode())) {
                    local = "x";
                }
                table.addRow().addContent(new Object[]{local, node.getId(), node.getAlias(), node.getHost(), node.getPort()});
            }
            table.print(System.out);
        } else {
            System.err.println("No node found in the cluster");
        }
        return null;
    }
}

