/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.felix.gogo.runtime.Closure;
import org.apache.felix.gogo.runtime.CommandSessionImpl;
import org.apache.felix.gogo.runtime.Token;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Parameter;

public final class Reflective {
    public static final Object NO_MATCH = new Object();
    public static final String MAIN = "_main";
    public static final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"));

    /*
     * WARNING - void declaration
     */
    public static Object invoke(CommandSession session, Object target, String name, List<Object> args) throws Exception {
        void var15_22;
        Object m2;
        Method[] methods = target.getClass().getMethods();
        String org = name = name.toLowerCase(Locale.ENGLISH);
        String get = "get" + name;
        String is = "is" + name;
        String set = "set" + name;
        if (KEYWORDS.contains(name)) {
            name = "_" + name;
        }
        if (target instanceof Class) {
            Method[] staticMethods;
            for (Object m2 : staticMethods = ((Class)target).getMethods()) {
                String mname = ((Method)m2).getName().toLowerCase(Locale.ENGLISH);
                if (!mname.equals(name) && !mname.equals(get) && !mname.equals(set) && !mname.equals(is) && !mname.equals(MAIN)) continue;
                methods = staticMethods;
                break;
            }
        }
        Object bestMethod = null;
        Object[] bestArgs = null;
        int lowestMatch = Integer.MAX_VALUE;
        ArrayList<Class<?>[]> possibleTypes = new ArrayList<Class<?>[]>();
        m2 = methods;
        int mname = ((Method[])m2).length;
        boolean bl = false;
        while (var15_22 < mname) {
            Object m3 = m2[var15_22];
            String mname2 = ((Method)m3).getName().toLowerCase(Locale.ENGLISH);
            if (mname2.equals(name) || mname2.equals(get) || mname2.equals(set) || mname2.equals(is) || mname2.equals(MAIN)) {
                Object[] parms;
                int match;
                Class<?>[] types = ((Method)m3).getParameterTypes();
                ArrayList<Object> xargs = new ArrayList<Object>(args);
                if (mname2.equals(MAIN)) {
                    xargs.add(0, org);
                }
                if ((match = Reflective.coerce(session, target, (Method)m3, types, parms = new Object[types.length], xargs)) < 0) {
                    possibleTypes.add(types);
                } else {
                    if (match < lowestMatch) {
                        lowestMatch = match;
                        bestMethod = m3;
                        bestArgs = parms;
                    }
                    if (match == 0) break;
                }
            }
            ++var15_22;
        }
        if (bestMethod != null) {
            ((Method)bestMethod).setAccessible(true);
            try {
                return ((Method)bestMethod).invoke(target, bestArgs);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                throw e;
            }
        }
        if (args.isEmpty()) {
            Field[] fields = target instanceof Class ? ((Class)target).getFields() : target.getClass().getFields();
            for (Field f : fields) {
                String mname3 = f.getName().toLowerCase(Locale.ENGLISH);
                if (!mname3.equals(name)) continue;
                return f.get(target);
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Class[] classArray : possibleTypes) {
            StringBuilder buf = new StringBuilder();
            buf.append('(');
            for (Class type : classArray) {
                if (buf.length() > 1) {
                    buf.append(", ");
                }
                buf.append(type.getSimpleName());
            }
            buf.append(')');
            list.add(buf.toString());
        }
        StringBuilder params = new StringBuilder();
        for (Object arg : args) {
            if (params.length() > 1) {
                params.append(", ");
            }
            params.append(arg == null ? "null" : arg.getClass().getSimpleName());
        }
        throw new IllegalArgumentException(String.format("Cannot coerce %s(%s) to any of %s", name, params, list));
    }

    private static List<Object> transformParameters(Method method, List<Object> in) {
        Annotation[][] pas = method.getParameterAnnotations();
        ArrayList<Object> out = new ArrayList<Object>();
        ArrayList<Object> parms = new ArrayList<Object>(in);
        Annotation[][] annotationArray = pas;
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] as;
            for (Annotation a : as = annotationArray[i]) {
                String name;
                if (!(a instanceof Parameter)) continue;
                int i2 = -1;
                Parameter p = (Parameter)a;
                String[] stringArray = p.names();
                int n2 = stringArray.length;
                for (int j = 0; j < n2 && (i2 = parms.indexOf(name = stringArray[j])) < 0; ++j) {
                }
                if (i2 >= 0) {
                    parms.remove(i2);
                    Object value = p.presentValue();
                    if ("org.apache.felix.service.command.unspecified.parameter".equals(value)) {
                        if (i2 >= parms.size()) {
                            return null;
                        }
                        value = parms.remove(i2);
                    }
                    out.add(value);
                    continue;
                }
                out.add(p.absentValue());
            }
        }
        out.addAll(parms);
        return out;
    }

    private static int coerce(CommandSession session, Object target, Method m, Class<?>[] types, Object[] out, List<Object> in) {
        Object[] out2;
        List<Object> cnvIn = new ArrayList<Object>();
        List<Object> cnvIn2 = new ArrayList<Object>();
        int different = 0;
        for (Object obj : in) {
            if (obj instanceof Token) {
                Object s1 = Closure.eval(obj);
                String s2 = obj.toString();
                cnvIn.add(s1);
                cnvIn2.add(s2);
                different += s2.equals(s1) ? 0 : 1;
                continue;
            }
            cnvIn.add(obj);
            cnvIn2.add(obj);
        }
        cnvIn = Reflective.transformParameters(m, cnvIn);
        if (different != 0) {
            cnvIn2 = Reflective.transformParameters(m, cnvIn2);
        }
        if (cnvIn == null || cnvIn2 == null) {
            return -1;
        }
        int res = Reflective.docoerce(session, target, m, types, out, cnvIn);
        if (different != 0 && res < 0) {
            res = Reflective.docoerce(session, target, m, types, out, cnvIn2);
        } else if (different != 0 && res > 0) {
            out2 = (Object[])out.clone();
            int res2 = Reflective.docoerce(session, target, m, types, out2, cnvIn2) + different * 2;
            if (res >= 0 && res2 <= res) {
                res = res2;
                System.arraycopy(out2, 0, out, 0, out.length);
            }
        }
        if (res < 0 && types.length > 0 && types[0].isInterface() && types[0].isAssignableFrom(session.getClass())) {
            cnvIn.add(0, session);
            res = Reflective.docoerce(session, target, m, types, out, cnvIn);
            if (different != 0 && res < 0) {
                cnvIn2.add(0, session);
                res = Reflective.docoerce(session, target, m, types, out, cnvIn2);
            } else if (different != 0 && res > 0) {
                cnvIn2.add(0, session);
                out2 = (Object[])out.clone();
                int res2 = Reflective.docoerce(session, target, m, types, out2, cnvIn2) + different * 2;
                if (res >= 0 && res2 <= res) {
                    res = res2;
                    System.arraycopy(out2, 0, out, 0, out.length);
                }
            }
        }
        return res;
    }

    private static int docoerce(CommandSession session, Object target, Method m, Class<?>[] types, Object[] out, List<Object> in) {
        int[] convert = new int[]{0};
        for (int i = 0; i < out.length; ++i) {
            out[i] = null;
            if (in.size() == 0 || i == types.length - 1 && types[i].isArray() && in.size() > 1) {
                out[i] = NO_MATCH;
            } else {
                out[i] = Reflective.coerce(session, types[i], in.get(0), convert);
                if (out[i] == null && types[i].isArray() && in.size() > 0) {
                    out[i] = NO_MATCH;
                }
                if (out[i] != NO_MATCH) {
                    in.remove(0);
                }
            }
            if (out[i] != NO_MATCH) continue;
            if (types[i].isArray() && i == types.length - 1) {
                Class<?> ctype = types[i].getComponentType();
                int asize = in.size();
                Object array = Array.newInstance(ctype, asize);
                int n = i;
                while (in.size() > 0) {
                    Object t = Reflective.coerce(session, ctype, in.remove(0), convert);
                    if (t == NO_MATCH) {
                        return -1;
                    }
                    Array.set(array, i - n, t);
                    ++i;
                }
                out[n] = array;
                return convert[0] + 1 + asize * 2;
            }
            return -1;
        }
        if (in.isEmpty()) {
            return convert[0];
        }
        return -1;
    }

    public static Object coerce(CommandSession session, Class<?> type, final Object arg, int[] convert) {
        if (arg == null) {
            return null;
        }
        if (type.isAssignableFrom(arg.getClass())) {
            return arg;
        }
        if (type.isArray() && arg instanceof Collection) {
            Collection col = (Collection)arg;
            return col.toArray((Object[])Array.newInstance(type.getComponentType(), col.size()));
        }
        if (type.isAssignableFrom(List.class) && arg.getClass().isArray()) {
            return new AbstractList<Object>(){

                @Override
                public Object get(int index) {
                    return Array.get(arg, index);
                }

                @Override
                public int size() {
                    return Array.getLength(arg);
                }
            };
        }
        if (type.isArray()) {
            return NO_MATCH;
        }
        if (type.isPrimitive() && arg instanceof Long) {
            Number num = (Number)arg;
            if (type == Short.TYPE) {
                return num.shortValue();
            }
            if (type == Integer.TYPE) {
                return num.intValue();
            }
            if (type == Long.TYPE) {
                return num.longValue();
            }
        }
        convert[0] = convert[0] + 2;
        Object converted = ((CommandSessionImpl)session).doConvert(type, arg);
        if (converted != null) {
            return converted;
        }
        String string = Reflective.toString(arg);
        if (type.isAssignableFrom(String.class)) {
            return string;
        }
        if (type.isEnum()) {
            for (Object o : type.getEnumConstants()) {
                if (!o.toString().equalsIgnoreCase(string)) continue;
                return o;
            }
        }
        if (type.isPrimitive()) {
            type = Reflective.primitiveToObject(type);
        }
        try {
            return type.getConstructor(String.class).newInstance(string);
        }
        catch (Exception exception) {
            if (type == Character.class && string.length() == 1) {
                return Character.valueOf(string.charAt(0));
            }
            return NO_MATCH;
        }
    }

    private static String toString(Object arg) {
        if (arg instanceof Map) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            boolean first = true;
            for (Map.Entry entry : ((Map)arg).entrySet()) {
                if (!first) {
                    sb.append(" ");
                }
                first = false;
                Reflective.writeValue(sb, entry.getKey());
                sb.append("=");
                Reflective.writeValue(sb, entry.getValue());
            }
            sb.append("]");
            return sb.toString();
        }
        if (arg instanceof Collection) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            boolean first = true;
            for (Object o : (Collection)arg) {
                if (!first) {
                    sb.append(" ");
                }
                first = false;
                Reflective.writeValue(sb, o);
            }
            sb.append("]");
            return sb.toString();
        }
        return arg.toString();
    }

    private static void writeValue(StringBuilder sb, Object o) {
        if (o == null || o instanceof Boolean || o instanceof Number) {
            sb.append(o);
        } else {
            String s = o.toString();
            sb.append("\"");
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '\"' || c == '=') {
                    sb.append("\\");
                }
                sb.append(c);
            }
            sb.append("\"");
        }
    }

    private static Class<?> primitiveToObject(Class<?> type) {
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        return null;
    }
}

