/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.persistence.spi;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.unomi.api.CustomItem;
import org.apache.unomi.api.Item;

public class ItemDeserializer
extends StdDeserializer<Item> {
    private static final long serialVersionUID = -7040054009670771266L;
    private Map<String, Class<? extends Item>> classes = new HashMap<String, Class<? extends Item>>();

    public ItemDeserializer() {
        super(Item.class);
    }

    public void registerMapping(String type, Class<? extends Item> clazz) {
        this.classes.put(type, clazz);
    }

    public Item deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectCodec codec = jp.getCodec();
        ObjectNode treeNode = (ObjectNode)codec.readTree(jp);
        String type = treeNode.get("itemType").textValue();
        Class<? extends Item> objectClass = this.classes.get(type);
        if (objectClass == null) {
            objectClass = CustomItem.class;
        } else {
            treeNode.remove("itemType");
        }
        Item item = (Item)codec.treeToValue((TreeNode)treeNode, objectClass);
        item.setItemId(treeNode.get("itemId").asText());
        return item;
    }
}

