/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.Transactional;
import org.apache.aries.transaction.TransactionalAnnotationAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentTxData {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentTxData.class);
    private static final int BANNED_MODIFIERS = 10;
    private Map<Method, Optional<TransactionalAnnotationAttributes>> txMap = new ConcurrentHashMap<Method, Optional<TransactionalAnnotationAttributes>>();
    private boolean isTransactional;
    private Class<?> beanClass;

    public ComponentTxData(Class<?> c) {
        this.beanClass = c;
        this.isTransactional = false;
        for (Class<?> current = c; current != Object.class; current = current.getSuperclass()) {
            this.isTransactional |= this.parseTxData(current);
            for (Class<?> iface : current.getInterfaces()) {
                this.isTransactional |= this.parseTxData(iface);
            }
        }
    }

    Optional<TransactionalAnnotationAttributes> getEffectiveType(Method m) {
        if (this.txMap.containsKey(m)) {
            return this.getTxAttr(m);
        }
        try {
            Method effectiveMethod = this.beanClass.getDeclaredMethod(m.getName(), m.getParameterTypes());
            Optional<TransactionalAnnotationAttributes> txAttr = this.getTxAttr(effectiveMethod);
            this.txMap.put(m, txAttr);
            return txAttr;
        }
        catch (NoSuchMethodException e) {
            return this.getFromMethod(m);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Security exception when determining effective method", e);
        }
    }

    private Optional<TransactionalAnnotationAttributes> getFromMethod(Method m) {
        try {
            Method effectiveMethod = this.beanClass.getMethod(m.getName(), m.getParameterTypes());
            Optional<TransactionalAnnotationAttributes> txAttr = this.getTxAttr(effectiveMethod);
            this.txMap.put(m, txAttr);
            return txAttr;
        }
        catch (NoSuchMethodException e1) {
            LOG.debug("No method found when scanning for transactions", (Throwable)e1);
            return Optional.empty();
        }
        catch (SecurityException e1) {
            throw new RuntimeException("Security exception when determining effective method", e1);
        }
    }

    private Optional<TransactionalAnnotationAttributes> getTxAttr(Method method) {
        Optional<TransactionalAnnotationAttributes> txAttr = this.txMap.get(method);
        if (txAttr == null) {
            return Optional.empty();
        }
        return txAttr;
    }

    private boolean parseTxData(Class<?> c) {
        boolean shouldAssignInterceptor = false;
        Transactional classAnnotation = c.getAnnotation(Transactional.class);
        Transactional.TxType defaultType = ComponentTxData.getType(classAnnotation);
        if (defaultType != null) {
            shouldAssignInterceptor = true;
        }
        for (Method m : c.getDeclaredMethods()) {
            try {
                Transactional methodAnnotation = m.getAnnotation(Transactional.class);
                Transactional.TxType t = ComponentTxData.getType(methodAnnotation);
                if (t != null) {
                    TransactionalAnnotationAttributes txData = new TransactionalAnnotationAttributes(t, methodAnnotation.dontRollbackOn(), methodAnnotation.rollbackOn());
                    ComponentTxData.assertAllowedModifier(m);
                    this.txMap.put(m, Optional.of(txData));
                    shouldAssignInterceptor = true;
                    continue;
                }
                if (defaultType == null) continue;
                this.txMap.put(m, Optional.of(new TransactionalAnnotationAttributes(defaultType, classAnnotation.dontRollbackOn(), classAnnotation.rollbackOn())));
            }
            catch (IllegalStateException e) {
                LOG.warn("Invalid transaction annoation found", (Throwable)e);
            }
        }
        return shouldAssignInterceptor;
    }

    private static Transactional.TxType getType(Transactional jtaT) {
        return jtaT != null ? jtaT.value() : null;
    }

    private static void assertAllowedModifier(Method m) {
        if ((m.getModifiers() & 0xA) != 0) {
            throw new IllegalArgumentException("Transaction annotation is not allowed on private or static method " + m);
        }
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }
}

