/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Set;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.LogListener;
import org.apache.camel.spi.MaskingFormatter;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.CamelLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogProcessor
extends ServiceSupport
implements AsyncProcessor,
Traceable,
IdAware {
    private static final Logger LOG = LoggerFactory.getLogger(LogProcessor.class);
    private String id;
    private final Expression expression;
    private final CamelLogger logger;
    private final MaskingFormatter formatter;
    private final Set<LogListener> listeners;

    public LogProcessor(Expression expression, CamelLogger logger, MaskingFormatter formatter, Set<LogListener> listeners) {
        this.expression = expression;
        this.logger = logger;
        this.formatter = formatter;
        this.listeners = listeners;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            if (this.logger.shouldLog()) {
                String msg = this.expression.evaluate(exchange, String.class);
                if (this.formatter != null) {
                    msg = this.formatter.format(msg);
                }
                msg = this.fireListeners(exchange, msg);
                this.logger.doLog(msg);
            }
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        finally {
            callback.done(true);
        }
        return true;
    }

    private String fireListeners(Exchange exchange, String message) {
        if (this.listeners == null) {
            return message;
        }
        for (LogListener listener : this.listeners) {
            if (listener == null) continue;
            try {
                String output = listener.onLog(exchange, this.logger, message);
                message = output != null ? output : message;
            }
            catch (Throwable t) {
                LOG.warn("Ignoring an exception thrown by {}: {}", (Object)listener.getClass().getName(), (Object)t.getMessage());
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("", t);
            }
        }
        return message;
    }

    public String toString() {
        return "Log(" + this.logger.getLog().getName() + ")[" + this.expression + "]";
    }

    @Override
    public String getTraceLabel() {
        return "log[" + this.expression + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public CamelLogger getLogger() {
        return this.logger;
    }

    public MaskingFormatter getLogFormatter() {
        return this.formatter;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

