/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.io.Serializable;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;

public abstract class Type
implements Serializable {
    public static final short ELEMENT = 1;
    public static final short ATTRIBUTE = 2;
    public static final short TEXT = 3;
    public static final short WHITESPACE_TEXT = 4;
    public static final short PROCESSING_INSTRUCTION = 7;
    public static final short COMMENT = 8;
    public static final short DOCUMENT = 9;
    public static final short NAMESPACE = 13;
    public static final short STOPPER = 11;
    public static final short PARENT_POINTER = 12;
    public static final short NODE = 0;
    public static final ItemType NODE_TYPE = AnyNodeTest.getInstance();
    public static final short ITEM = 88;
    public static final ItemType ITEM_TYPE = AnyItemType.getInstance();
    public static final short MAX_NODE_TYPE = 13;
    public static final short EMPTY = 15;
    public static final int ANY_ATOMIC = 632;
    public static final int NUMBER = 635;
    public static final int STRING = 513;
    public static final int BOOLEAN = 514;
    public static final int DECIMAL = 515;
    public static final int FLOAT = 516;
    public static final int DOUBLE = 517;
    public static final int DURATION = 518;
    public static final int DATE_TIME = 519;
    public static final int TIME = 520;
    public static final int DATE = 521;
    public static final int G_YEAR_MONTH = 522;
    public static final int G_YEAR = 523;
    public static final int G_MONTH_DAY = 524;
    public static final int G_DAY = 525;
    public static final int G_MONTH = 526;
    public static final int HEX_BINARY = 527;
    public static final int BASE64_BINARY = 528;
    public static final int ANY_URI = 529;
    public static final int QNAME = 530;
    public static final int NOTATION = 531;
    public static final int UNTYPED_ATOMIC = 631;
    public static final int ANY_SIMPLE_TYPE = 573;
    public static final int OBJECT = 285;
    public static final int INTEGER = 532;
    public static final int NON_POSITIVE_INTEGER = 533;
    public static final int NEGATIVE_INTEGER = 534;
    public static final int LONG = 535;
    public static final int INT = 536;
    public static final int SHORT = 537;
    public static final int BYTE = 538;
    public static final int NON_NEGATIVE_INTEGER = 539;
    public static final int POSITIVE_INTEGER = 540;
    public static final int UNSIGNED_LONG = 541;
    public static final int UNSIGNED_INT = 542;
    public static final int UNSIGNED_SHORT = 543;
    public static final int UNSIGNED_BYTE = 544;
    public static final int NORMALIZED_STRING = 553;
    public static final int TOKEN = 554;
    public static final int LANGUAGE = 555;
    public static final int NMTOKEN = 556;
    public static final int NMTOKENS = 557;
    public static final int NAME = 558;
    public static final int NCNAME = 559;
    public static final int ID = 560;
    public static final int IDREF = 561;
    public static final int IDREFS = 562;
    public static final int ENTITY = 563;
    public static final int YEAR_MONTH_DURATION = 633;
    public static final int DAY_TIME_DURATION = 634;

    private Type() {
    }

    public static boolean isNodeType(ItemType itemType) {
        return itemType instanceof NodeTest;
    }

    public static ItemType getItemType(Item item, TypeHierarchy typeHierarchy) {
        if (item instanceof AtomicValue) {
            return ((AtomicValue)item).getItemType(typeHierarchy);
        }
        return NodeKindTest.makeNodeKindTest(((NodeInfo)item).getNodeKind());
    }

    public static final String displayTypeName(Item item) {
        if (item instanceof NodeInfo) {
            NodeInfo nodeInfo = (NodeInfo)item;
            switch (nodeInfo.getNodeKind()) {
                case 9: {
                    return "document-node()";
                }
                case 1: {
                    NamePool namePool = nodeInfo.getNamePool();
                    int n = nodeInfo.getTypeAnnotation();
                    return "element(" + ((NodeInfo)item).getDisplayName() + ", " + (n == -1 ? "xs:untyped)" : namePool.getDisplayName(n) + ')');
                }
                case 2: {
                    NamePool namePool = nodeInfo.getNamePool();
                    int n = nodeInfo.getTypeAnnotation() & 0xFFFFF;
                    return "attribute(" + ((NodeInfo)item).getDisplayName() + ", " + (n == -1 ? "xs:untypedAtomic)" : namePool.getDisplayName(n) + ')');
                }
                case 3: {
                    return "text()";
                }
                case 8: {
                    return "comment()";
                }
                case 7: {
                    return "processing-instruction()";
                }
                case 13: {
                    return "namespace()";
                }
            }
            return "";
        }
        if (item instanceof ObjectValue) {
            return ((ObjectValue)item).displayTypeName();
        }
        return ((AtomicValue)item).getItemType(null).toString();
    }

    public static ItemType getBuiltInItemType(String string, String string2) {
        SchemaType schemaType = BuiltInType.getSchemaType(StandardNames.getFingerprint(string, string2));
        if (schemaType instanceof ItemType) {
            return (ItemType)((Object)schemaType);
        }
        return null;
    }

    public static int schemaTypeRelationship(SchemaType schemaType, SchemaType schemaType2) {
        if (schemaType.isSameType(schemaType2)) {
            return 0;
        }
        if (schemaType instanceof AnyType) {
            return 1;
        }
        if (schemaType2 instanceof AnyType) {
            return 2;
        }
        SchemaType schemaType3 = schemaType;
        while ((schemaType3 = schemaType3.getBaseType()) != null) {
            if (!schemaType3.isSameType(schemaType2)) continue;
            return 2;
        }
        SchemaType schemaType4 = schemaType2;
        while ((schemaType4 = schemaType4.getBaseType()) != null) {
            if (!schemaType4.isSameType(schemaType)) continue;
            return 1;
        }
        return 4;
    }

    public static final ItemType getCommonSuperType(ItemType itemType, ItemType itemType2, TypeHierarchy typeHierarchy) {
        if (itemType instanceof EmptySequenceTest) {
            return itemType2;
        }
        if (itemType2 instanceof EmptySequenceTest) {
            return itemType;
        }
        int n = typeHierarchy.relationship(itemType, itemType2);
        if (n == 0) {
            return itemType;
        }
        if (n == 2) {
            return itemType2;
        }
        if (n == 1) {
            return itemType;
        }
        return Type.getCommonSuperType(itemType2.getSuperType(typeHierarchy), itemType, typeHierarchy);
    }

    public static boolean isPrimitiveType(int n) {
        return n >= 0 && (n <= 532 || n == 635 || n == 631 || n == 632 || n == 634 || n == 633 || n == 573);
    }

    public static boolean isComparable(BuiltInAtomicType builtInAtomicType, BuiltInAtomicType builtInAtomicType2, boolean bl) {
        if (builtInAtomicType.equals(BuiltInAtomicType.ANY_ATOMIC) || builtInAtomicType2.equals(BuiltInAtomicType.ANY_ATOMIC)) {
            return true;
        }
        if (builtInAtomicType.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            builtInAtomicType = BuiltInAtomicType.STRING;
        }
        if (builtInAtomicType2.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            builtInAtomicType2 = BuiltInAtomicType.STRING;
        }
        if (builtInAtomicType.equals(BuiltInAtomicType.ANY_URI)) {
            builtInAtomicType = BuiltInAtomicType.STRING;
        }
        if (builtInAtomicType2.equals(BuiltInAtomicType.ANY_URI)) {
            builtInAtomicType2 = BuiltInAtomicType.STRING;
        }
        if (builtInAtomicType.isPrimitiveNumeric()) {
            builtInAtomicType = BuiltInAtomicType.NUMERIC;
        }
        if (builtInAtomicType2.isPrimitiveNumeric()) {
            builtInAtomicType2 = BuiltInAtomicType.NUMERIC;
        }
        if (!bl) {
            if (builtInAtomicType.equals(BuiltInAtomicType.DAY_TIME_DURATION)) {
                builtInAtomicType = BuiltInAtomicType.DURATION;
            }
            if (builtInAtomicType2.equals(BuiltInAtomicType.DAY_TIME_DURATION)) {
                builtInAtomicType2 = BuiltInAtomicType.DURATION;
            }
            if (builtInAtomicType.equals(BuiltInAtomicType.YEAR_MONTH_DURATION)) {
                builtInAtomicType = BuiltInAtomicType.DURATION;
            }
            if (builtInAtomicType2.equals(BuiltInAtomicType.YEAR_MONTH_DURATION)) {
                builtInAtomicType2 = BuiltInAtomicType.DURATION;
            }
        }
        return builtInAtomicType == builtInAtomicType2;
    }
}

