/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.deployment.impl;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.uima.aae.deployment.AEDeploymentConstants;
import org.apache.uima.aae.deployment.AEDeploymentDescription;
import org.apache.uima.aae.deployment.AEService;
import org.apache.uima.aae.deployment.impl.AEService_Impl;
import org.apache.uima.aae.deployment.impl.DDParserUtil;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.internal.util.XMLUtils;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.OperationalProperties;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLParser;
import org.apache.uima.util.XMLSerializer;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class AEDeploymentDescription_Impl
extends MetaDataObject_impl
implements AEDeploymentDescription,
AEDeploymentConstants {
    protected String name = "";
    protected String description = "";
    protected String version = "";
    protected String vendor = "";
    protected String protocol = "";
    protected String provider = "";
    protected int casPoolSize = 5;
    protected int initialFsHeapSize = 2000000;
    protected AEService aeService = new AEService_Impl();
    private static final XmlizationInfo XMLIZATION_INFO = new XmlizationInfo("analysisEngineDeploymentDescription", new PropertyXmlInfo[]{new PropertyXmlInfo("cpeDescriptor", false), new PropertyXmlInfo("defaultCasProcessorSettings", false)});

    public void buildFromXMLElement(Element aElement, XMLParser aParser, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        NodeList childNodes = aElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node curNode = childNodes.item(i);
            if (!(curNode instanceof Element)) continue;
            Element elem = (Element)curNode;
            if ("name".equalsIgnoreCase(elem.getTagName())) {
                this.setName(XMLUtils.getText((Element)elem));
                continue;
            }
            if ("description".equalsIgnoreCase(elem.getTagName())) {
                this.setDescription(XMLUtils.getText((Element)elem));
                continue;
            }
            if ("version".equalsIgnoreCase(elem.getTagName())) {
                this.setVersion(XMLUtils.getText((Element)elem));
                continue;
            }
            if ("vendor".equalsIgnoreCase(elem.getTagName())) {
                this.setVendor(XMLUtils.getText((Element)elem));
                continue;
            }
            if ("deployment".equalsIgnoreCase(elem.getTagName())) {
                this.buildTopDeployment(elem, aParser, aOptions);
                continue;
            }
            throw new InvalidXMLException("unknown_element", new Object[]{elem.getTagName()});
        }
    }

    public String toString() {
        StringWriter w = new StringWriter();
        try {
            this.toXML(w);
            return w.toString();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    private void buildTopDeployment(Element aElement, XMLParser aParser, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        NamedNodeMap map = aElement.getAttributes();
        if (map != null) {
            for (int i = 0; i < map.getLength(); ++i) {
                Node item = map.item(i);
                String name = item.getNodeName();
                String val = item.getNodeValue();
                val = val == null ? "" : val.trim();
                if ("protocol".equalsIgnoreCase(name)) {
                    this.setProtocol(val);
                    continue;
                }
                if ("provider".equalsIgnoreCase(name)) {
                    this.setProvider(val);
                    continue;
                }
                throw new InvalidXMLException("unknown_element", new Object[]{name});
            }
        }
        if (this.getProtocol() == null) {
            throw new InvalidXMLException("element_not_found", new Object[]{"protocol", "deployment"});
        }
        if (this.getProvider() == null) {
            throw new InvalidXMLException("element_not_found", new Object[]{"provider", "deployment"});
        }
        NodeList childNodes = aElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node curNode = childNodes.item(i);
            if (!(curNode instanceof Element)) continue;
            Element elem = (Element)curNode;
            if ("casPool".equalsIgnoreCase(elem.getTagName())) {
                String val = DDParserUtil.checkAndGetAttributeValue("casPool", "numberOfCASes", elem, true);
                if (val != null && val.trim().length() > 0) {
                    try {
                        this.casPoolSize = Integer.parseInt(val);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        throw new InvalidXMLException("unknown_element", new Object[]{"casPool"}, (Throwable)e);
                    }
                }
                if ((val = DDParserUtil.checkAndGetAttributeValue("casPool", "initialFsHeapSize", elem, false)) == null || val.trim().length() <= 0) continue;
                try {
                    this.initialFsHeapSize = Integer.parseInt(val);
                    continue;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    throw new InvalidXMLException("unknown_element", new Object[]{"initialFsHeapSize"}, (Throwable)e);
                }
            }
            if ("service".equalsIgnoreCase(elem.getTagName())) {
                this.aeService = (AEService)aParser.buildObject(elem, aOptions);
                continue;
            }
            throw new InvalidXMLException("unknown_element", new Object[]{elem.getTagName()});
        }
    }

    public void toXML(ContentHandler aContentHandler, boolean aWriteDefaultNamespaceAttribute) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        aContentHandler.startElement(this.getXmlizationInfo().namespace, "analysisEngineDeploymentDescription", "analysisEngineDeploymentDescription", attrs);
        aContentHandler.startElement("", "", "name", attrs);
        String valStr = this.getName();
        aContentHandler.characters(valStr.toCharArray(), 0, valStr.length());
        aContentHandler.endElement("", "", "name");
        aContentHandler.startElement("", "", "description", attrs);
        valStr = AEDeploymentDescription_Impl.multiLineFix(this.getDescription());
        aContentHandler.characters(valStr.toCharArray(), 0, valStr.length());
        aContentHandler.endElement("", "", "description");
        aContentHandler.startElement("", "", "version", attrs);
        valStr = this.getVersion();
        aContentHandler.characters(valStr.toCharArray(), 0, valStr.length());
        aContentHandler.endElement("", "", "version");
        aContentHandler.startElement("", "", "vendor", attrs);
        valStr = this.getVendor();
        aContentHandler.characters(valStr.toCharArray(), 0, valStr.length());
        aContentHandler.endElement("", "", "vendor");
        attrs.addAttribute("", "protocol", "protocol", null, this.protocol);
        attrs.addAttribute("", "provider", "provider", null, this.provider);
        aContentHandler.startElement("", "", "deployment", attrs);
        attrs.clear();
        attrs.addAttribute("", "numberOfCASes", "numberOfCASes", null, "" + this.casPoolSize);
        attrs.addAttribute("", "initialFsHeapSize", "initialFsHeapSize", null, "" + this.initialFsHeapSize);
        aContentHandler.startElement("", "", "casPool", attrs);
        aContentHandler.endElement("", "", "casPool");
        attrs.clear();
        this.aeService.toXML(aContentHandler, aWriteDefaultNamespaceAttribute);
        aContentHandler.endElement("", "", "deployment");
        attrs.clear();
        aContentHandler.endElement(this.getXmlizationInfo().namespace, "analysisEngineDeploymentDescription", "analysisEngineDeploymentDescription");
    }

    public static String multiLineFix(String s) {
        if (null == s) {
            return null;
        }
        return s.replaceAll("\\r\\n", "\n");
    }

    public String prettyPrint(int indent) {
        StringWriter writer = new StringWriter();
        String parsedText = null;
        try {
            XMLSerializer xmlSerializer = new XMLSerializer(true);
            xmlSerializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "" + indent);
            xmlSerializer.setWriter((Writer)writer);
            ContentHandler contentHandler = xmlSerializer.getContentHandler();
            contentHandler.startDocument();
            this.toXML(contentHandler, true);
            contentHandler.endDocument();
            writer.close();
            parsedText = writer.toString();
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return parsedText;
    }

    public static boolean isCASMultiplier(ResourceSpecifier rs) {
        if (rs != null) {
            if (rs instanceof AnalysisEngineDescription) {
                return AEDeploymentDescription_Impl.isCASMultiplier((AnalysisEngineDescription)rs);
            }
            if (rs instanceof CollectionReaderDescription) {
                return true;
            }
        }
        return false;
    }

    public static boolean isCASMultiplier(AnalysisEngineDescription ae) {
        return AEDeploymentDescription_Impl.isCASMultiplier(ae.getAnalysisEngineMetaData());
    }

    public static boolean isCASMultiplier(AnalysisEngineMetaData meta) {
        OperationalProperties op = meta.getOperationalProperties();
        if (op != null) {
            return op.getOutputsNewCASes();
        }
        return false;
    }

    protected XmlizationInfo getXmlizationInfo() {
        return new XmlizationInfo(null, null);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    @Override
    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    @Override
    public void setProvider(String provider) {
        this.provider = provider;
    }

    @Override
    public AEService getAeService() {
        return this.aeService;
    }

    @Override
    public void setAeService(AEService aeService) {
        this.aeService = aeService;
    }

    @Override
    public int getCasPoolSize() {
        return this.casPoolSize;
    }

    @Override
    public void setCasPoolSize(int casPoolSize) {
        this.casPoolSize = casPoolSize;
    }

    @Override
    public int getInitialFsHeapSize() {
        return this.initialFsHeapSize;
    }

    @Override
    public void setInitialFsHeapSize(int initialSize) {
        this.initialFsHeapSize = initialSize;
    }
}

