/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.testing.ui.views;

import org.apache.uima.ruta.caseditor.view.tree.AnnotationTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.PrimitiveFeatureTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.TextUtils;
import org.apache.uima.ruta.caseditor.view.tree.TypeTreeNode;
import org.apache.uima.ruta.testing.ui.views.EvaluationViewPage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class EvaluationLabelProvider
extends LabelProvider
implements ILabelProvider {
    private EvaluationViewPage owner;

    public EvaluationLabelProvider() {
    }

    public EvaluationLabelProvider(EvaluationViewPage owner) {
        this.owner = owner;
    }

    public String getText(Object element) {
        AnnotationTreeNode fnNode;
        if (element instanceof AnnotationTreeNode && (fnNode = (AnnotationTreeNode)element).getAnnotation() != null) {
            String typeName = fnNode.getAnnotation().getType().getName();
            String coveredText = fnNode.getAnnotation().getCoveredText();
            coveredText = coveredText.replaceAll("[\\n]", "").replaceAll("[\\r]", "");
            if (typeName.equals("org.apache.uima.ruta.type.FalsePositive") || typeName.equals("org.apache.uima.ruta.type.FalseNegative") || typeName.equals("org.apache.uima.ruta.type.TruePositive")) {
                return coveredText;
            }
            String name = TextUtils.shrinkNamespace((String)fnNode.getAnnotation().getType().getName());
            return name + ": " + coveredText;
        }
        if (element instanceof TypeTreeNode) {
            TypeTreeNode testNode = (TypeTreeNode)element;
            return TextUtils.shrinkNamespace((String)testNode.getType().getName());
        }
        if (element instanceof PrimitiveFeatureTreeNode) {
            PrimitiveFeatureTreeNode fNode = (PrimitiveFeatureTreeNode)element;
            return fNode.getName();
        }
        return "error";
    }

    public Image getImage(Object element) {
        return null;
    }
}

