/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.peer.managers;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.fulcrum.security.torque.TorqueAbstractUserManager;
import org.apache.fulcrum.security.torque.peer.Peer;
import org.apache.fulcrum.security.torque.peer.PeerManagable;
import org.apache.fulcrum.security.torque.peer.PeerManager;
import org.apache.fulcrum.security.torque.peer.TorqueTurbinePeer;
import org.apache.fulcrum.security.torque.peer.TorqueTurbineUserGroupRolePeer;
import org.apache.fulcrum.security.util.DataBackendException;

public abstract class PeerUserManager
extends TorqueAbstractUserManager
implements PeerManagable {
    private static final long serialVersionUID = 1L;
    private Boolean customPeer = false;
    private String peerClassName;
    private static final String PEER_CLASS_NAME_KEY = "peerClassName";
    transient PeerManager peerManager;
    private String columnName = "LOGIN_NAME";
    private String columnName4UserGroupRole = "USER_ID";
    private String userGroupRolePeerClassName;

    @Override
    public void configure(Configuration conf) throws ConfigurationException {
        super.configure(conf);
        this.peerClassName = conf.getChild(PEER_CLASS_NAME_KEY).getValue(null);
        if (this.peerClassName != null) {
            this.setPeerClassName(this.peerClassName);
            this.setCustomPeer(true);
        }
        Configuration[] userGroupRoleConf = conf.getChild("userGroupRoleManager").getChildren();
        for (int i = 0; i < userGroupRoleConf.length; ++i) {
            Configuration configuration = userGroupRoleConf[i];
            if (!configuration.getName().equals(PEER_CLASS_NAME_KEY)) continue;
            this.userGroupRolePeerClassName = configuration.getValue(null);
            if (this.userGroupRolePeerClassName == null) continue;
            this.setUserGroupRolePeerClassName(this.userGroupRolePeerClassName);
            this.setCustomPeer(true);
        }
        if (this.peerClassName != null && this.userGroupRolePeerClassName == null) {
            throw new ConfigurationException("If using peers in component configuration (xml) the element userManager expects to have a userGroupRoleManager child element with peerClassName child element.");
        }
    }

    @Override
    public Peer getPeerInstance() throws DataBackendException {
        return this.getPeerManager().getPeerInstance(this.getPeerClassName(), TorqueTurbinePeer.class, this.getClassName());
    }

    public Peer getUserGroupRolePeerInstance() throws DataBackendException {
        return this.getPeerManager().getPeerInstance(this.getUserGroupRolePeerClassName(), TorqueTurbineUserGroupRolePeer.class, this.getClassName());
    }

    @Override
    public PeerManager getPeerManager() {
        if (this.peerManager == null) {
            this.peerManager = (PeerManager)this.resolve(PeerManager.ROLE);
        }
        return this.peerManager;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    @Override
    public Boolean getCustomPeer() {
        return this.customPeer;
    }

    @Override
    public void setCustomPeer(Boolean customPeer) {
        this.customPeer = customPeer;
    }

    @Override
    public String getPeerClassName() {
        return this.peerClassName;
    }

    @Override
    public void setPeerClassName(String peerClassName) {
        this.peerClassName = peerClassName;
    }

    public String getUserGroupRolePeerClassName() {
        return this.userGroupRolePeerClassName;
    }

    public void setUserGroupRolePeerClassName(String userGroupRolePeerClassName) {
        this.userGroupRolePeerClassName = userGroupRolePeerClassName;
    }

    public String getColumnName4UserGroupRole() {
        return this.columnName4UserGroupRole;
    }

    public void setColumnName4UserGroupRole(String columnName4UserGroupRole) {
        this.columnName4UserGroupRole = columnName4UserGroupRole;
    }
}

