/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.openejb.server.SimpleServiceManager;

public class FilteredServiceManager
extends SimpleServiceManager {
    private final Collection<String> services;

    public FilteredServiceManager(String[] services) {
        FilteredServiceManager.setServiceManager(this);
        this.services = this.convertServices(services);
    }

    private Collection<String> convertServices(String[] services) {
        HashSet<String> realServices = new HashSet<String>();
        List<String> rsAliases = Arrays.asList("rest", "jaxrs", "jax-rs", "cxf-rs");
        List<String> wsAliases = Arrays.asList("jaxws", "jax-ws", "cxf");
        for (String service : services) {
            if (rsAliases.contains(service)) {
                realServices.addAll(Arrays.asList("cxf-rs", "httpejbd"));
                continue;
            }
            if (wsAliases.contains(service)) {
                realServices.addAll(Arrays.asList("cxf", "httpejbd"));
                continue;
            }
            if ("http".equals(service)) {
                realServices.add("httpejbd");
                continue;
            }
            realServices.add(service);
        }
        return realServices;
    }

    @Override
    protected boolean accept(String serviceName) {
        return this.services.isEmpty() || this.services.contains(serviceName);
    }

    public static void initServiceManager(String[] services) {
        FilteredServiceManager.setServiceManager(new FilteredServiceManager(services));
    }
}

