/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.dictionary;

import java.io.DataInput;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.bitmap.ABitmap;
import org.apache.sysds.runtime.compress.bitmap.Bitmap;
import org.apache.sysds.runtime.compress.bitmap.MultiColBitmap;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.AColGroupCompressed;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.IContainADictionary;
import org.apache.sysds.runtime.compress.colgroup.IContainDefaultTuple;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.PlaceHolderDict;
import org.apache.sysds.runtime.compress.colgroup.dictionary.QDictionary;
import org.apache.sysds.runtime.compress.lib.CLALibCombineGroups;
import org.apache.sysds.runtime.compress.utils.ACount;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.compress.utils.DblArrayCountHashMap;
import org.apache.sysds.runtime.compress.utils.DoubleCountHashMap;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.SparseRowVector;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public interface DictionaryFactory {
    public static final Log LOG = LogFactory.getLog((String)DictionaryFactory.class.getName());

    public static IDictionary read(DataInput in) throws IOException {
        Type type = Type.values()[in.readByte()];
        switch (type) {
            case FP64_DICT: {
                return Dictionary.read(in);
            }
            case MATRIX_BLOCK_DICT: {
                return MatrixBlockDictionary.read(in);
            }
            case INT8_DICT: {
                return QDictionary.read(in);
            }
            case PLACE_HOLDER: {
                return PlaceHolderDict.read(in);
            }
        }
        throw new DMLCompressionException("Unsupported type of dictionary : " + type);
    }

    public static long getInMemorySize(int nrValues, int nrColumns, double tupleSparsity, boolean lossy) {
        if (lossy) {
            return QDictionary.getInMemorySize(nrValues * nrColumns);
        }
        if (nrColumns > 1 && tupleSparsity < 0.4) {
            return MatrixBlockDictionary.getInMemorySize(nrValues, nrColumns, tupleSparsity);
        }
        return Dictionary.getInMemorySize(nrValues * nrColumns);
    }

    public static IDictionary create(DblArrayCountHashMap map, int nCols, boolean addZeroTuple, double sparsity) {
        try {
            ACount<T>[] vals = map.extractValues();
            int nVals = vals.length;
            int nTuplesOut = nVals + (addZeroTuple ? 1 : 0);
            if (sparsity < 0.4) {
                MatrixBlock retB = new MatrixBlock(nTuplesOut, nCols, true);
                retB.allocateSparseRowsBlock();
                SparseBlock sb = retB.getSparseBlock();
                for (int i = 0; i < nVals; ++i) {
                    ACount dac = vals[i];
                    double[] dv = ((DblArray)dac.key()).getData();
                    for (int k = 0; k < dv.length; ++k) {
                        sb.append(dac.id, k, dv[k]);
                    }
                }
                retB.recomputeNonZeros();
                retB.examSparsity(true);
                return MatrixBlockDictionary.create(retB);
            }
            double[] resValues = new double[nTuplesOut * nCols];
            for (int i = 0; i < nVals; ++i) {
                ACount dac = vals[i];
                System.arraycopy(((DblArray)dac.key()).getData(), 0, resValues, dac.id * nCols, nCols);
            }
            return Dictionary.create(resValues);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create dictionary: " + map + " " + nCols, e);
        }
    }

    public static IDictionary create(ABitmap ubm) {
        return DictionaryFactory.create(ubm, 1.0);
    }

    public static IDictionary create(ABitmap ubm, double sparsity, boolean withZeroTuple) {
        return withZeroTuple ? DictionaryFactory.createWithAppendedZeroTuple(ubm, sparsity) : DictionaryFactory.create(ubm, sparsity);
    }

    public static IDictionary create(ABitmap ubm, double sparsity) {
        int nCol = ubm.getNumColumns();
        if (ubm instanceof Bitmap) {
            return Dictionary.create(((Bitmap)ubm).getValues());
        }
        if (sparsity < 0.4 && nCol > 4 && ubm instanceof MultiColBitmap) {
            MultiColBitmap mcbm = (MultiColBitmap)ubm;
            MatrixBlock m = new MatrixBlock(ubm.getNumValues(), nCol, true);
            m.allocateSparseRowsBlock();
            SparseBlock sb = m.getSparseBlock();
            int nVals = ubm.getNumValues();
            for (int i = 0; i < nVals; ++i) {
                double[] tuple = mcbm.getValues(i);
                for (int col = 0; col < nCol; ++col) {
                    sb.append(i, col, tuple[col]);
                }
            }
            m.recomputeNonZeros();
            m.examSparsity(true);
            return MatrixBlockDictionary.create(m);
        }
        if (ubm instanceof MultiColBitmap) {
            MultiColBitmap mcbm = (MultiColBitmap)ubm;
            int nVals = ubm.getNumValues();
            double[] resValues = new double[nVals * nCol];
            for (int i = 0; i < nVals; ++i) {
                System.arraycopy(mcbm.getValues(i), 0, resValues, i * nCol, nCol);
            }
            return Dictionary.create(resValues);
        }
        throw new NotImplementedException("Not implemented creation of bitmap type : " + ubm.getClass().getSimpleName());
    }

    public static IDictionary create(ABitmap ubm, int defaultIndex, double[] defaultTuple, double sparsity, boolean addZero) {
        int nCol = ubm.getNumColumns();
        int nVal = ubm.getNumValues() - (addZero ? 0 : 1);
        if (nCol > 4 && sparsity < 0.4) {
            int i;
            MultiColBitmap mcbm = (MultiColBitmap)ubm;
            MatrixBlock m = new MatrixBlock(nVal, nCol, true);
            m.allocateSparseRowsBlock();
            SparseBlock sb = m.getSparseBlock();
            for (i = 0; i < defaultIndex; ++i) {
                sb.set(i, new SparseRowVector(mcbm.getValues(i)), false);
            }
            System.arraycopy(mcbm.getValues(defaultIndex), 0, defaultTuple, 0, nCol);
            for (i = defaultIndex; i < ubm.getNumValues() - 1; ++i) {
                sb.set(i, new SparseRowVector(mcbm.getValues(i + 1)), false);
            }
            m.recomputeNonZeros();
            m.examSparsity(true);
            return MatrixBlockDictionary.create(m);
        }
        double[] dict = new double[nCol * nVal];
        if (ubm instanceof Bitmap) {
            double[] bmv = ((Bitmap)ubm).getValues();
            System.arraycopy(bmv, 0, dict, 0, defaultIndex);
            defaultTuple[0] = bmv[defaultIndex];
            System.arraycopy(bmv, defaultIndex + 1, dict, defaultIndex, bmv.length - defaultIndex - 1);
        } else if (ubm instanceof MultiColBitmap) {
            int i;
            MultiColBitmap mcbm = (MultiColBitmap)ubm;
            for (i = 0; i < defaultIndex; ++i) {
                System.arraycopy(mcbm.getValues(i), 0, dict, i * nCol, nCol);
            }
            System.arraycopy(mcbm.getValues(defaultIndex), 0, defaultTuple, 0, nCol);
            for (i = defaultIndex; i < ubm.getNumValues() - 1; ++i) {
                System.arraycopy(mcbm.getValues(i + 1), 0, dict, i * nCol, nCol);
            }
        } else {
            throw new NotImplementedException("not supported ABitmap of type:" + ubm.getClass().getSimpleName());
        }
        return Dictionary.create(dict);
    }

    public static IDictionary createWithAppendedZeroTuple(ABitmap ubm, double sparsity) {
        int nVals = ubm.getNumValues();
        int nRows = nVals + 1;
        int nCols = ubm.getNumColumns();
        if (ubm instanceof Bitmap) {
            double[] resValues = new double[nRows];
            double[] from = ((Bitmap)ubm).getValues();
            System.arraycopy(from, 0, resValues, 0, from.length);
            return Dictionary.create(resValues);
        }
        MultiColBitmap mcbm = (MultiColBitmap)ubm;
        if (sparsity < 0.4 && nCols > 4) {
            MatrixBlock m = new MatrixBlock(nRows, nCols, true);
            m.allocateSparseRowsBlock();
            SparseBlock sb = m.getSparseBlock();
            for (int i = 0; i < nVals; ++i) {
                double[] tuple = mcbm.getValues(i);
                for (int col = 0; col < nCols; ++col) {
                    sb.append(i, col, tuple[col]);
                }
            }
            m.recomputeNonZeros();
            m.examSparsity(true);
            return MatrixBlockDictionary.create(m);
        }
        double[] resValues = new double[nRows * nCols];
        for (int i = 0; i < nVals; ++i) {
            System.arraycopy(mcbm.getValues(i), 0, resValues, i * nCols, nCols);
        }
        return Dictionary.create(resValues);
    }

    public static IDictionary create(DoubleCountHashMap map) {
        double[] resValues = map.getDictionary();
        return Dictionary.create(resValues);
    }

    public static IDictionary combineDictionaries(AColGroupCompressed a, AColGroupCompressed b) {
        return DictionaryFactory.combineDictionaries(a, b, null);
    }

    public static IDictionary combineDictionaries(AColGroupCompressed a, AColGroupCompressed b, Map<Integer, Integer> filter) {
        if (a instanceof ColGroupEmpty && b instanceof ColGroupEmpty) {
            return null;
        }
        AColGroup.CompressionType ac = a.getCompType();
        AColGroup.CompressionType bc = b.getCompType();
        boolean ae = a instanceof IContainADictionary;
        boolean be = b instanceof IContainADictionary;
        if (ae && be) {
            IDictionary ad = ((IContainADictionary)((Object)a)).getDictionary();
            IDictionary bd = ((IContainADictionary)((Object)b)).getDictionary();
            if (ac.isConst()) {
                if (bc.isConst()) {
                    return Dictionary.create(CLALibCombineGroups.constructDefaultTuple(a, b));
                }
                if (bc.isDense()) {
                    double[] at = ((IContainDefaultTuple)((Object)a)).getDefaultTuple();
                    return DictionaryFactory.combineConstSparseSparseRet(at, bd, b.getNumCols(), filter);
                }
            } else if (ac.isDense()) {
                if (bc.isConst()) {
                    double[] bt = ((IContainDefaultTuple)((Object)b)).getDefaultTuple();
                    return DictionaryFactory.combineSparseConstSparseRet(ad, a.getNumCols(), bt, filter);
                }
                if (bc.isDense()) {
                    return DictionaryFactory.combineFullDictionaries(ad, a.getNumCols(), bd, b.getNumCols(), filter);
                }
                if (bc.isSDC()) {
                    double[] tuple = ((IContainDefaultTuple)((Object)b)).getDefaultTuple();
                    return DictionaryFactory.combineSDCRight(ad, a.getNumCols(), bd, tuple, filter);
                }
            } else if (ac.isSDC() && bc.isSDC()) {
                double[] at = ((IContainDefaultTuple)((Object)a)).getDefaultTuple();
                double[] bt = ((IContainDefaultTuple)((Object)b)).getDefaultTuple();
                return DictionaryFactory.combineSDC(ad, at, bd, bt, filter);
            }
        }
        throw new NotImplementedException("Not supporting combining: " + a + " " + b);
    }

    public static IDictionary combineDictionariesSparse(AColGroupCompressed a, AColGroupCompressed b) {
        AColGroup.CompressionType ac = a.getCompType();
        AColGroup.CompressionType bc = b.getCompType();
        if (ac.isSDC()) {
            IDictionary ad = ((IContainADictionary)((Object)a)).getDictionary();
            if (bc.isConst()) {
                double[] bt = ((IContainDefaultTuple)((Object)b)).getDefaultTuple();
                return DictionaryFactory.combineSparseConstSparseRet(ad, a.getNumCols(), bt);
            }
            if (bc.isSDC()) {
                IDictionary bd = ((IContainADictionary)((Object)b)).getDictionary();
                if (a.sameIndexStructure(b)) {
                    return ad.cbind(bd, b.getNumCols());
                }
            }
        } else if (ac.isConst()) {
            double[] at = ((IContainDefaultTuple)((Object)a)).getDefaultTuple();
            if (bc.isSDC()) {
                IDictionary bd = ((IContainADictionary)((Object)b)).getDictionary();
                return DictionaryFactory.combineConstSparseSparseRet(at, bd, b.getNumCols());
            }
        }
        throw new NotImplementedException("Not supporting combining dense: " + a + " " + b);
    }

    public static IDictionary combineFullDictionaries(IDictionary a, int nca, IDictionary b, int ncb) {
        return DictionaryFactory.combineFullDictionaries(a, nca, b, ncb, null);
    }

    public static IDictionary combineFullDictionaries(IDictionary a, int nca, IDictionary b, int ncb, Map<Integer, Integer> filter) {
        int ra = a.getNumberOfValues(nca);
        int rb = b.getNumberOfValues(ncb);
        MatrixBlock ma = a.getMBDict(nca).getMatrixBlock();
        MatrixBlock mb = b.getMBDict(ncb).getMatrixBlock();
        if (ra == 1 && rb == 1) {
            return new MatrixBlockDictionary(ma.append(mb));
        }
        MatrixBlock out = new MatrixBlock(filter != null ? filter.size() : ra * rb, nca + ncb, false);
        out.allocateBlock();
        if (filter != null) {
            for (int r : filter.keySet()) {
                int c;
                int o = filter.get(r);
                int ia = r % ra;
                int ib = r / ra;
                for (c = 0; c < nca; ++c) {
                    out.quickSetValue(o, c, ma.quickGetValue(ia, c));
                }
                for (c = 0; c < ncb; ++c) {
                    out.quickSetValue(o, c + nca, mb.quickGetValue(ib, c));
                }
            }
        } else {
            for (int r = 0; r < out.getNumRows(); ++r) {
                int c;
                int ia = r % ra;
                int ib = r / ra;
                for (c = 0; c < nca; ++c) {
                    out.quickSetValue(r, c, ma.quickGetValue(ia, c));
                }
                for (c = 0; c < ncb; ++c) {
                    out.quickSetValue(r, c + nca, mb.quickGetValue(ib, c));
                }
            }
        }
        return new MatrixBlockDictionary(out);
    }

    public static IDictionary combineSDCRight(IDictionary a, int nca, IDictionary b, double[] tub) {
        int r;
        int ncb = tub.length;
        int ra = a.getNumberOfValues(nca);
        int rb = b.getNumberOfValues(ncb);
        MatrixBlock ma = a.getMBDict(nca).getMatrixBlock();
        MatrixBlock mb = b.getMBDict(ncb).getMatrixBlock();
        MatrixBlock out = new MatrixBlock(ra * (rb + 1), nca + ncb, false);
        out.allocateBlock();
        for (r = 0; r < ra; ++r) {
            int c;
            for (c = 0; c < nca; ++c) {
                out.quickSetValue(r, c, ma.quickGetValue(r, c));
            }
            for (c = 0; c < ncb; ++c) {
                out.quickSetValue(r, c + nca, tub[c]);
            }
        }
        for (r = ra; r < out.getNumRows(); ++r) {
            int c;
            int ia = r % ra;
            int ib = r / ra - 1;
            for (c = 0; c < nca; ++c) {
                out.quickSetValue(r, c, ma.quickGetValue(ia, c));
            }
            for (c = 0; c < ncb; ++c) {
                out.quickSetValue(r, c + nca, mb.quickGetValue(ib, c));
            }
        }
        return new MatrixBlockDictionary(out);
    }

    public static IDictionary combineSDCRight(IDictionary a, int nca, IDictionary b, double[] tub, Map<Integer, Integer> filter) {
        int o;
        int r;
        if (filter == null) {
            return DictionaryFactory.combineSDCRight(a, nca, b, tub);
        }
        int ncb = tub.length;
        int ra = a.getNumberOfValues(nca);
        int rb = b.getNumberOfValues(ncb);
        MatrixBlock ma = a.getMBDict(nca).getMatrixBlock();
        MatrixBlock mb = b.getMBDict(ncb).getMatrixBlock();
        MatrixBlock out = new MatrixBlock(filter.size(), nca + ncb, false);
        out.allocateBlock();
        for (r = 0; r < ra; ++r) {
            int c;
            if (!filter.containsKey(r)) continue;
            o = filter.get(r);
            for (c = 0; c < nca; ++c) {
                out.quickSetValue(o, c, ma.quickGetValue(r, c));
            }
            for (c = 0; c < ncb; ++c) {
                out.quickSetValue(o, c + nca, tub[c]);
            }
        }
        for (r = ra; r < ra * rb; ++r) {
            int c;
            if (!filter.containsKey(r)) continue;
            o = filter.get(r);
            int ia = r % ra;
            int ib = r / ra - 1;
            for (c = 0; c < nca; ++c) {
                out.quickSetValue(o, c, ma.quickGetValue(ia, c));
            }
            for (c = 0; c < ncb; ++c) {
                out.quickSetValue(o, c + nca, mb.quickGetValue(ib, c));
            }
        }
        return new MatrixBlockDictionary(out);
    }

    public static IDictionary combineSDC(IDictionary a, double[] tua, IDictionary b, double[] tub) {
        int r;
        int c;
        int nca = tua.length;
        int ncb = tub.length;
        int ra = a.getNumberOfValues(nca);
        int rb = b.getNumberOfValues(ncb);
        MatrixBlock ma = a.getMBDict(nca).getMatrixBlock();
        MatrixBlock mb = b.getMBDict(ncb).getMatrixBlock();
        MatrixBlock out = new MatrixBlock((ra + 1) * (rb + 1), nca + ncb, false);
        out.allocateBlock();
        for (c = 0; c < nca; ++c) {
            out.quickSetValue(0, c, tua[c]);
        }
        for (c = 0; c < ncb; ++c) {
            out.quickSetValue(0, c + nca, tub[c]);
        }
        for (r = 1; r < ra + 1; ++r) {
            int c2;
            for (c2 = 0; c2 < nca; ++c2) {
                out.quickSetValue(r, c2, ma.quickGetValue(r - 1, c2));
            }
            for (c2 = 0; c2 < ncb; ++c2) {
                out.quickSetValue(r, c2 + nca, tub[c2]);
            }
        }
        for (r = ra + 1; r < out.getNumRows(); ++r) {
            int c3;
            int ia = r % (ra + 1) - 1;
            int ib = r / (ra + 1) - 1;
            if (ia == -1) {
                for (c3 = 0; c3 < nca; ++c3) {
                    out.quickSetValue(r, c3, tua[c3]);
                }
            } else {
                for (c3 = 0; c3 < nca; ++c3) {
                    out.quickSetValue(r, c3, ma.quickGetValue(ia, c3));
                }
            }
            for (c3 = 0; c3 < ncb; ++c3) {
                out.quickSetValue(r, c3 + nca, mb.quickGetValue(ib, c3));
            }
        }
        return new MatrixBlockDictionary(out);
    }

    public static IDictionary combineSDC(IDictionary a, double[] tua, IDictionary b, double[] tub, Map<Integer, Integer> filter) {
        int o;
        int r;
        if (filter == null) {
            return DictionaryFactory.combineSDC(a, tua, b, tub);
        }
        int nca = tua.length;
        int ncb = tub.length;
        int ra = a.getNumberOfValues(nca);
        int rb = b.getNumberOfValues(nca);
        MatrixBlock ma = a.getMBDict(nca).getMatrixBlock();
        MatrixBlock mb = b.getMBDict(ncb).getMatrixBlock();
        MatrixBlock out = new MatrixBlock(filter.size(), nca + ncb, false);
        out.allocateBlock();
        if (filter.containsKey(0)) {
            int c;
            int o2 = filter.get(0);
            for (c = 0; c < nca; ++c) {
                out.quickSetValue(o2, c, tua[c]);
            }
            for (c = 0; c < ncb; ++c) {
                out.quickSetValue(o2, c + nca, tub[c]);
            }
        }
        for (r = 1; r < ra + 1; ++r) {
            int c;
            if (!filter.containsKey(r)) continue;
            o = filter.get(r);
            for (c = 0; c < nca; ++c) {
                out.quickSetValue(o, c, ma.quickGetValue(r - 1, c));
            }
            for (c = 0; c < ncb; ++c) {
                out.quickSetValue(o, c + nca, tub[c]);
            }
        }
        for (r = ra + 1; r < ra * rb; ++r) {
            int c;
            if (!filter.containsKey(r)) continue;
            o = filter.get(r);
            int ia = r % (ra + 1) - 1;
            int ib = r / (ra + 1) - 1;
            if (ia == -1) {
                for (c = 0; c < nca; ++c) {
                    out.quickSetValue(o, c, tua[c]);
                }
            } else {
                for (c = 0; c < nca; ++c) {
                    out.quickSetValue(o, c, ma.quickGetValue(ia, c));
                }
            }
            for (c = 0; c < ncb; ++c) {
                out.quickSetValue(o, c + nca, mb.quickGetValue(ib, c));
            }
        }
        return new MatrixBlockDictionary(out);
    }

    public static IDictionary combineSparseConstSparseRet(IDictionary a, int nca, double[] tub) {
        int ncb = tub.length;
        int ra = a.getNumberOfValues(nca);
        MatrixBlock ma = a.getMBDict(nca).getMatrixBlock();
        MatrixBlock out = new MatrixBlock(ra, nca + ncb, false);
        out.allocateBlock();
        for (int r = 0; r < ra; ++r) {
            int c;
            for (c = 0; c < nca; ++c) {
                out.quickSetValue(r, c, ma.quickGetValue(r, c));
            }
            for (c = 0; c < ncb; ++c) {
                out.quickSetValue(r, c + nca, tub[c]);
            }
        }
        return new MatrixBlockDictionary(out);
    }

    private static IDictionary combineSparseConstSparseRet(IDictionary a, int nca, double[] tub, Map<Integer, Integer> filter) {
        if (filter == null) {
            return DictionaryFactory.combineSparseConstSparseRet(a, nca, tub);
        }
        throw new NotImplementedException();
    }

    public static IDictionary combineConstSparseSparseRet(double[] tua, IDictionary b, int ncb) {
        int nca = tua.length;
        int rb = b.getNumberOfValues(ncb);
        MatrixBlock mb = b.getMBDict(ncb).getMatrixBlock();
        MatrixBlock out = new MatrixBlock(rb, nca + ncb, false);
        out.allocateBlock();
        for (int r = 0; r < rb; ++r) {
            int c;
            for (c = 0; c < nca; ++c) {
                out.quickSetValue(r, c, tua[c]);
            }
            for (c = 0; c < ncb; ++c) {
                out.quickSetValue(r, c + nca, mb.quickGetValue(r, c));
            }
        }
        return new MatrixBlockDictionary(out);
    }

    private static IDictionary combineConstSparseSparseRet(double[] tua, IDictionary b, int ncb, Map<Integer, Integer> filter) {
        if (filter == null) {
            return DictionaryFactory.combineConstSparseSparseRet(tua, b, ncb);
        }
        throw new NotImplementedException();
    }

    public static enum Type {
        FP64_DICT,
        MATRIX_BLOCK_DICT,
        INT8_DICT,
        IDENTITY,
        IDENTITY_SLICE,
        PLACE_HOLDER;

    }
}

