/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.data;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.sysds.runtime.data.SparseRow;
import org.apache.sysds.runtime.util.SortUtils;
import org.apache.sysds.runtime.util.UtilFunctions;

public final class SparseRowVector
extends SparseRow
implements Serializable {
    private static final long serialVersionUID = 2971077474424464992L;
    public static final int initialCapacity = 4;
    private int estimatedNzs = 4;
    private int maxNzs = Integer.MAX_VALUE;
    private int size = 0;
    private double[] values = null;
    private int[] indexes = null;

    public SparseRowVector() {
        this(4);
    }

    public SparseRowVector(int capacity) {
        this.estimatedNzs = capacity;
        this.values = new double[capacity];
        this.indexes = new int[capacity];
    }

    public SparseRowVector(int estnnz, int maxnnz) {
        if (estnnz > 4) {
            this.estimatedNzs = estnnz;
        }
        this.maxNzs = maxnnz;
        int capacity = estnnz < 4 && estnnz > 0 ? estnnz : 4;
        this.values = new double[capacity];
        this.indexes = new int[capacity];
    }

    public SparseRowVector(SparseRow that) {
        this.size = that.size();
        int cap = Math.max(4, that.size());
        this.values = Arrays.copyOf(that.values(), cap);
        this.indexes = Arrays.copyOf(that.indexes(), cap);
    }

    @Override
    public int size() {
        return this.size;
    }

    public void setSize(int newsize) {
        this.size = newsize;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public double[] values() {
        return this.values;
    }

    @Override
    public int[] indexes() {
        return this.indexes;
    }

    public void setValues(double[] d) {
        this.values = d;
    }

    public void setIndexes(int[] i) {
        this.indexes = i;
    }

    public int capacity() {
        return this.values.length;
    }

    public void copy(SparseRow that) {
        int thatSize = that.size();
        if (this.values.length < thatSize) {
            this.values = Arrays.copyOf(that.values(), thatSize);
            this.indexes = Arrays.copyOf(that.indexes(), thatSize);
        } else {
            System.arraycopy(that.values(), 0, this.values, 0, thatSize);
            System.arraycopy(that.indexes(), 0, this.indexes, 0, thatSize);
        }
        this.size = thatSize;
    }

    @Override
    public void reset(int estnns, int maxnns) {
        this.estimatedNzs = estnns;
        this.maxNzs = maxnns;
        this.size = 0;
    }

    private void recap(int newCap) {
        if (newCap <= this.values.length) {
            return;
        }
        this.values = Arrays.copyOf(this.values, newCap);
        this.indexes = Arrays.copyOf(this.indexes, newCap);
    }

    private int newCapacity() {
        double currLen;
        int nextLen = (int)Math.ceil(currLen * ((currLen = (double)this.values.length) < (double)this.estimatedNzs ? 2.0 : 1.1));
        return Math.max(2, Math.min(this.maxNzs, nextLen));
    }

    @Override
    public boolean set(int col, double v) {
        int index = Arrays.binarySearch(this.indexes, 0, this.size, col);
        if (index >= 0) {
            if (v == 0.0) {
                this.shiftLeftAndDelete(index);
                return true;
            }
            this.values[index] = v;
            return false;
        }
        if (v == 0.0) {
            return false;
        }
        index = Math.abs(index + 1);
        if (this.size == this.values.length) {
            this.resizeAndInsert(index, col, v);
        } else {
            this.shiftRightAndInsert(index, col, v);
        }
        return true;
    }

    @Override
    public boolean add(int col, double v) {
        if (v == 0.0) {
            return false;
        }
        int index = Arrays.binarySearch(this.indexes, 0, this.size, col);
        if (index >= 0) {
            int n = index;
            this.values[n] = this.values[n] + v;
            return false;
        }
        index = Math.abs(index + 1);
        if (this.size == this.values.length) {
            this.resizeAndInsert(index, col, v);
        } else {
            this.shiftRightAndInsert(index, col, v);
        }
        return true;
    }

    @Override
    public void append(int col, double v) {
        if (v == 0.0) {
            return;
        }
        if (this.size == this.values.length) {
            this.recap(this.newCapacity());
        }
        this.values[this.size] = v;
        this.indexes[this.size] = col;
        ++this.size;
    }

    @Override
    public double get(int col) {
        int index = Arrays.binarySearch(this.indexes, 0, this.size, col);
        return index >= 0 ? this.values[index] : 0.0;
    }

    public int searchIndexesFirstLTE(int col) {
        if (this.size == 0) {
            return -1;
        }
        int index = Arrays.binarySearch(this.indexes, 0, this.size, col);
        if (index >= 0) {
            return index < this.size ? index : -1;
        }
        return (index = Math.abs(index + 1)) - 1 < this.size ? index - 1 : -1;
    }

    public int searchIndexesFirstGTE(int col) {
        if (this.size == 0) {
            return -1;
        }
        int index = Arrays.binarySearch(this.indexes, 0, this.size, col);
        if (index >= 0) {
            return index < this.size ? index : -1;
        }
        return (index = Math.abs(index + 1)) < this.size ? index : -1;
    }

    public int searchIndexesFirstGT(int col) {
        if (this.size == 0) {
            return -1;
        }
        int index = Arrays.binarySearch(this.indexes, 0, this.size, col);
        if (index >= 0) {
            return index + 1 < this.size ? index + 1 : -1;
        }
        return (index = Math.abs(index + 1)) < this.size ? index : -1;
    }

    public void deleteIndexRange(int lowerCol, int upperCol) {
        int start = this.searchIndexesFirstGTE(lowerCol);
        if (start < 0) {
            return;
        }
        int end = this.searchIndexesFirstGT(upperCol);
        if (end < 0) {
            end = this.size;
        }
        System.arraycopy(this.values, end, this.values, start, this.size - end);
        System.arraycopy(this.indexes, end, this.indexes, start, this.size - end);
        this.size -= end - start;
    }

    public void setIndexRange(int cl, int cu, double[] v, int vix, int vlen) {
        int start = this.searchIndexesFirstGTE(cl);
        if (start < 0) {
            for (int i = vix; i < vix + vlen; ++i) {
                this.append(cl + i - vix, v[i]);
            }
            return;
        }
        int end = this.searchIndexesFirstGT(cu);
        if (end < 0) {
            this.size = start;
            for (int i = vix; i < vix + vlen; ++i) {
                this.append(cl + i - vix, v[i]);
            }
            return;
        }
        int lnnz = UtilFunctions.computeNnz(v, vix, vlen);
        int lsize = this.size + lnnz - (end - start);
        if (this.values.length < lsize) {
            this.recap(lsize);
        }
        this.shiftRightByN(end, lnnz - (end - start));
        int pos = start;
        for (int i = vix; i < vix + vlen; ++i) {
            if (v[i] == 0.0) continue;
            this.values[pos] = v[i];
            this.indexes[pos] = cl + i - vix;
            ++pos;
        }
    }

    public void setIndexRange(int cl, int cu, double[] v, int[] vix, int vpos, int vlen) {
        int start = this.searchIndexesFirstGTE(cl);
        if (start < 0) {
            for (int i = vpos; i < vpos + vlen; ++i) {
                this.append(cl + vix[i], v[i]);
            }
            return;
        }
        int end = this.searchIndexesFirstGT(cu);
        if (end < 0) {
            this.size = start;
            for (int i = vpos; i < vpos + vlen; ++i) {
                this.append(cl + vix[i], v[i]);
            }
            return;
        }
        int lsize = this.size + vlen - (end - start);
        if (this.values.length < lsize) {
            this.recap(lsize);
        }
        this.shiftRightByN(end, vlen - (end - start));
        int pos = start;
        for (int i = vpos; i < vpos + vlen; ++i) {
            this.values[pos] = v[i];
            this.indexes[pos] = cl + vix[i];
            ++pos;
        }
    }

    private void resizeAndInsert(int index, int col, double v) {
        int newCap = this.newCapacity();
        double[] oldvalues = this.values;
        int[] oldindexes = this.indexes;
        this.values = new double[newCap];
        this.indexes = new int[newCap];
        System.arraycopy(oldvalues, 0, this.values, 0, index);
        System.arraycopy(oldindexes, 0, this.indexes, 0, index);
        this.indexes[index] = col;
        this.values[index] = v;
        System.arraycopy(oldvalues, index, this.values, index + 1, this.size - index);
        System.arraycopy(oldindexes, index, this.indexes, index + 1, this.size - index);
        ++this.size;
    }

    private void shiftRightAndInsert(int index, int col, double v) {
        System.arraycopy(this.values, index, this.values, index + 1, this.size - index);
        System.arraycopy(this.indexes, index, this.indexes, index + 1, this.size - index);
        this.values[index] = v;
        this.indexes[index] = col;
        ++this.size;
    }

    private void shiftRightByN(int index, int n) {
        System.arraycopy(this.values, index, this.values, index + n, this.size - index);
        System.arraycopy(this.indexes, index, this.indexes, index + n, this.size - index);
        this.size += n;
    }

    private void shiftLeftAndDelete(int index) {
        System.arraycopy(this.values, index + 1, this.values, index, this.size - index - 1);
        System.arraycopy(this.indexes, index + 1, this.indexes, index, this.size - index - 1);
        --this.size;
    }

    @Override
    public void sort() {
        if (this.size <= 100 || !SortUtils.isSorted(0, this.size, this.indexes)) {
            SortUtils.sortByIndex(0, this.size, this.indexes, this.values);
        }
    }

    @Override
    public void compact() {
        int nnz = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.values[i] == 0.0) continue;
            this.values[nnz] = this.values[i];
            this.indexes[nnz] = this.indexes[i];
            ++nnz;
        }
        this.size = nnz;
    }
}

