/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.compress.CompressedMatrixBlockFactory;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class CompressionCPInstruction
extends ComputationCPInstruction {
    private CompressionCPInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String istr) {
        super(CPInstruction.CPType.Compression, op, in, null, null, out, opcode, istr);
    }

    public static CompressionCPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        return new CompressionCPInstruction(null, in1, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        MatrixBlock in = ec.getMatrixInput(this.input1.getName());
        MatrixBlock out = (MatrixBlock)CompressedMatrixBlockFactory.compress(in, OptimizerUtils.getConstrainedNumThreads(-1)).getLeft();
        ec.releaseMatrixInput(this.input1.getName());
        ec.setMatrixOutput(this.output.getName(), out);
    }
}

