/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.functionobjects.CM;
import org.apache.sysml.runtime.functionobjects.COV;
import org.apache.sysml.runtime.instructions.mr.CM_N_COVInstruction;
import org.apache.sysml.runtime.matrix.data.CM_N_COVCell;
import org.apache.sysml.runtime.matrix.data.TaggedFirstSecondIndexes;
import org.apache.sysml.runtime.matrix.data.WeightedPair;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.matrix.mapred.MapperBase;
import org.apache.sysml.runtime.matrix.operators.CMOperator;
import org.apache.sysml.runtime.matrix.operators.COVOperator;

public class CMCOVMRMapper
extends MapperBase
implements Mapper<Writable, Writable, Writable, Writable> {
    private boolean firsttime = true;
    private HashMap<Byte, CM> cmFn = new HashMap();
    private COV covFn = COV.getCOMFnObject();
    private OutputCollector<Writable, Writable> cachedCollector = null;
    private CachedValueMap cmNcovCache = new CachedValueMap();
    protected HashSet<Byte> cmTags = new HashSet();
    protected HashSet<Byte> covTags = new HashSet();

    public void map(Writable index, Writable cell, OutputCollector<Writable, Writable> out, Reporter report) throws IOException {
        if (this.firsttime) {
            this.cachedCollector = out;
            this.firsttime = false;
        }
        this.commonMap(index, cell, out, report);
    }

    @Override
    protected void specialOperationsForActualMap(int index, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
        this.processMapperInstructionsForMatrix(index);
        for (byte tag : this.cmTags) {
            CM lcmFn = this.cmFn.get(tag);
            IndexedMatrixValue input = this.cachedValues.getFirst(tag);
            if (input == null) continue;
            WeightedPair inputPair = (WeightedPair)input.getValue();
            CM_N_COVCell cmValue = (CM_N_COVCell)this.cmNcovCache.getFirst(tag).getValue();
            try {
                lcmFn.execute(cmValue.getCM_N_COVObject(), inputPair.getValue(), inputPair.getWeight());
            }
            catch (DMLRuntimeException e) {
                throw new IOException(e);
            }
        }
        for (byte tag : this.covTags) {
            IndexedMatrixValue input = this.cachedValues.getFirst(tag);
            if (input == null) continue;
            WeightedPair inputPair = (WeightedPair)input.getValue();
            CM_N_COVCell comValue = (CM_N_COVCell)this.cmNcovCache.getFirst(tag).getValue();
            try {
                this.covFn.execute(comValue.getCM_N_COVObject(), inputPair.getValue(), inputPair.getOtherValue(), inputPair.getWeight());
            }
            catch (DMLRuntimeException e) {
                throw new IOException(e);
            }
        }
    }

    public void close() throws IOException {
        if (this.cachedCollector != null) {
            for (byte tag : this.cmTags) {
                CM_N_COVCell cmValue = (CM_N_COVCell)this.cmNcovCache.getFirst(tag).getValue();
                this.cachedCollector.collect((Object)new TaggedFirstSecondIndexes(1L, tag, 1L), (Object)cmValue);
            }
            for (byte tag : this.covTags) {
                CM_N_COVCell comValue = (CM_N_COVCell)this.cmNcovCache.getFirst(tag).getValue();
                this.cachedCollector.collect((Object)new TaggedFirstSecondIndexes(1L, tag, 1L), (Object)comValue);
            }
        }
    }

    @Override
    public void configure(JobConf job) {
        super.configure(job);
        try {
            CM_N_COVInstruction[] cmIns;
            for (CM_N_COVInstruction ins : cmIns = MRJobConfiguration.getCM_N_COVInstructions(job)) {
                if (ins.getOperator() instanceof COVOperator) {
                    this.covTags.add(ins.input);
                    continue;
                }
                this.cmTags.add(ins.input);
                this.cmFn.put(ins.input, CM.getCMFnObject(((CMOperator)ins.getOperator()).getAggOpType()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (byte tag : this.cmTags) {
            this.cmNcovCache.holdPlace(tag, CM_N_COVCell.class);
        }
        for (byte tag : this.covTags) {
            this.cmNcovCache.holdPlace(tag, CM_N_COVCell.class);
        }
    }
}

