/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.EquiJoin;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;

public abstract class FilterJoinRule
extends RelOptRule {
    public static final Predicate TRUE_PREDICATE = new Predicate(){

        @Override
        public boolean apply(Join join, JoinRelType joinType, RexNode exp) {
            return true;
        }
    };
    public static final FilterJoinRule FILTER_ON_JOIN = new FilterIntoJoinRule(true, RelFactories.LOGICAL_BUILDER, TRUE_PREDICATE);
    public static final FilterJoinRule DUMB_FILTER_ON_JOIN = new FilterIntoJoinRule(false, RelFactories.LOGICAL_BUILDER, TRUE_PREDICATE);
    public static final FilterJoinRule JOIN = new JoinConditionPushRule(RelFactories.LOGICAL_BUILDER, TRUE_PREDICATE);
    private final boolean smart;
    private final Predicate predicate;

    protected FilterJoinRule(RelOptRuleOperand operand, String id, boolean smart, RelBuilderFactory relBuilderFactory, Predicate predicate) {
        super(operand, relBuilderFactory, "FilterJoinRule:" + id);
        this.smart = smart;
        this.predicate = (Predicate)Preconditions.checkNotNull((Object)predicate);
    }

    @Deprecated
    protected FilterJoinRule(RelOptRuleOperand operand, String id, boolean smart, RelFactories.FilterFactory filterFactory, RelFactories.ProjectFactory projectFactory) {
        this(operand, id, smart, RelBuilder.proto(filterFactory, projectFactory), TRUE_PREDICATE);
    }

    @Deprecated
    protected FilterJoinRule(RelOptRuleOperand operand, String id, boolean smart, RelFactories.FilterFactory filterFactory, RelFactories.ProjectFactory projectFactory, Predicate predicate) {
        this(operand, id, smart, RelBuilder.proto(filterFactory, projectFactory), predicate);
    }

    protected void perform(RelOptRuleCall call, Filter filter, Join join) {
        List<RexNode> joinFilters = RelOptUtil.conjunctions(join.getCondition());
        ImmutableList origJoinFilters = ImmutableList.copyOf(joinFilters);
        if (filter == null && joinFilters.isEmpty()) {
            return;
        }
        ArrayList aboveFilters = filter != null ? RelOptUtil.conjunctions(filter.getCondition()) : Lists.newArrayList();
        ImmutableList origAboveFilters = ImmutableList.copyOf((Collection)aboveFilters);
        JoinRelType joinType = join.getJoinType();
        if (this.smart && !origAboveFilters.isEmpty() && join.getJoinType() != JoinRelType.INNER) {
            joinType = RelOptUtil.simplifyJoin(join, (ImmutableList<RexNode>)origAboveFilters, joinType);
        }
        ArrayList<RexNode> leftFilters = new ArrayList<RexNode>();
        ArrayList<RexNode> rightFilters = new ArrayList<RexNode>();
        boolean filterPushed = false;
        if (RelOptUtil.classifyFilters(join, aboveFilters, joinType, !(join instanceof EquiJoin), !joinType.generatesNullsOnLeft(), !joinType.generatesNullsOnRight(), joinFilters, leftFilters, rightFilters)) {
            filterPushed = true;
        }
        this.validateJoinFilters(aboveFilters, joinFilters, join, joinType);
        if (leftFilters.isEmpty() && rightFilters.isEmpty() && joinFilters.size() == origJoinFilters.size() && Sets.newHashSet(joinFilters).equals(Sets.newHashSet((Iterable)origJoinFilters))) {
            filterPushed = false;
        }
        if (RelOptUtil.classifyFilters(join, joinFilters, joinType, false, !joinType.generatesNullsOnRight(), !joinType.generatesNullsOnLeft(), joinFilters, leftFilters, rightFilters)) {
            filterPushed = true;
        }
        if (!filterPushed && joinType == join.getJoinType() || joinFilters.isEmpty() && leftFilters.isEmpty() && rightFilters.isEmpty()) {
            return;
        }
        RexBuilder rexBuilder = join.getCluster().getRexBuilder();
        RelBuilder relBuilder = call.builder();
        RelNode leftRel = relBuilder.push(join.getLeft()).filter(leftFilters).build();
        RelNode rightRel = relBuilder.push(join.getRight()).filter(rightFilters).build();
        ImmutableList fieldTypes = ImmutableList.builder().addAll(RelOptUtil.getFieldTypeList(leftRel.getRowType())).addAll(RelOptUtil.getFieldTypeList(rightRel.getRowType())).build();
        RexNode joinFilter = RexUtil.composeConjunction(rexBuilder, RexUtil.fixUp(rexBuilder, joinFilters, (List<RelDataType>)fieldTypes), false);
        if (joinFilter.isAlwaysTrue() && leftFilters.isEmpty() && rightFilters.isEmpty() && joinType == join.getJoinType()) {
            return;
        }
        Join newJoinRel = join.copy(join.getTraitSet(), joinFilter, leftRel, rightRel, joinType, join.isSemiJoinDone());
        call.getPlanner().onCopy(join, newJoinRel);
        if (!leftFilters.isEmpty()) {
            call.getPlanner().onCopy(filter, leftRel);
        }
        if (!rightFilters.isEmpty()) {
            call.getPlanner().onCopy(filter, rightRel);
        }
        relBuilder.push(newJoinRel);
        relBuilder.convert(join.getRowType(), false);
        relBuilder.filter(RexUtil.fixUp(rexBuilder, (List<RexNode>)aboveFilters, RelOptUtil.getFieldTypeList(relBuilder.peek().getRowType())));
        call.transformTo(relBuilder.build());
    }

    protected void validateJoinFilters(List<RexNode> aboveFilters, List<RexNode> joinFilters, Join join, JoinRelType joinType) {
        Iterator<RexNode> filterIter = joinFilters.iterator();
        while (filterIter.hasNext()) {
            RexNode exp = filterIter.next();
            if (this.predicate.apply(join, joinType, exp)) continue;
            aboveFilters.add(exp);
            filterIter.remove();
        }
    }

    public static interface Predicate {
        public boolean apply(Join var1, JoinRelType var2, RexNode var3);
    }

    public static class FilterIntoJoinRule
    extends FilterJoinRule {
        public FilterIntoJoinRule(boolean smart, RelBuilderFactory relBuilderFactory, Predicate predicate) {
            super(FilterIntoJoinRule.operand(Filter.class, FilterIntoJoinRule.operand(Join.class, RelOptRule.any()), new RelOptRuleOperand[0]), "FilterJoinRule:filter", smart, relBuilderFactory, predicate);
        }

        @Deprecated
        public FilterIntoJoinRule(boolean smart, RelFactories.FilterFactory filterFactory, RelFactories.ProjectFactory projectFactory, Predicate predicate) {
            this(smart, RelBuilder.proto(filterFactory, projectFactory), predicate);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            Join join = (Join)call.rel(1);
            this.perform(call, filter, join);
        }
    }

    public static class JoinConditionPushRule
    extends FilterJoinRule {
        public JoinConditionPushRule(RelBuilderFactory relBuilderFactory, Predicate predicate) {
            super(RelOptRule.operand(Join.class, RelOptRule.any()), "FilterJoinRule:no-filter", true, relBuilderFactory, predicate);
        }

        @Deprecated
        public JoinConditionPushRule(RelFactories.FilterFactory filterFactory, RelFactories.ProjectFactory projectFactory, Predicate predicate) {
            this(RelBuilder.proto(filterFactory, projectFactory), predicate);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Join join = (Join)call.rel(0);
            this.perform(call, null, join);
        }
    }
}

