/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.UserDataValue;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.sql.GenericParameter;

final class GenericParameterValueSet
implements ParameterValueSet {
    private final GenericParameter[] parms;
    final ClassInspector ci;
    private final boolean hasReturnOutputParam;

    GenericParameterValueSet(ClassInspector classInspector, int n, boolean bl) {
        this.ci = classInspector;
        this.hasReturnOutputParam = bl;
        this.parms = new GenericParameter[n];
        for (int i = 0; i < n; ++i) {
            this.parms[i] = new GenericParameter(this, bl && i == 0);
        }
    }

    private GenericParameterValueSet(int n, GenericParameterValueSet genericParameterValueSet) {
        this.hasReturnOutputParam = genericParameterValueSet.hasReturnOutputParam;
        this.ci = genericParameterValueSet.ci;
        this.parms = new GenericParameter[n];
        for (int i = 0; i < n; ++i) {
            this.parms[i] = genericParameterValueSet.getGenericParameter(i).getClone(this);
        }
    }

    public void initialize(DataTypeDescriptor[] dataTypeDescriptorArray) throws StandardException {
        for (int i = 0; i < this.parms.length; ++i) {
            DataTypeDescriptor dataTypeDescriptor = dataTypeDescriptorArray[i];
            this.parms[i].initialize(dataTypeDescriptor.getNull(), dataTypeDescriptor.getJDBCTypeId(), dataTypeDescriptor.getTypeId().getCorrespondingJavaTypeName());
        }
    }

    public void setParameterMode(int n, int n2) {
        this.parms[n].parameterMode = (short)n2;
    }

    public void clearParameters() {
        for (int i = 0; i < this.parms.length; ++i) {
            this.parms[i].clear();
        }
    }

    public int getParameterCount() {
        return this.parms.length;
    }

    public DataValueDescriptor getParameter(int n) throws StandardException {
        try {
            return this.parms[n].getValue();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.checkPosition(n);
            return null;
        }
    }

    public DataValueDescriptor getParameterForSet(int n) throws StandardException {
        try {
            GenericParameter genericParameter = this.parms[n];
            if (genericParameter.parameterMode == 4) {
                throw StandardException.newException("XCL27.S");
            }
            genericParameter.isSet = true;
            return genericParameter.getValue();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.checkPosition(n);
            return null;
        }
    }

    public DataValueDescriptor getParameterForGet(int n) throws StandardException {
        try {
            GenericParameter genericParameter = this.parms[n];
            switch (genericParameter.parameterMode) {
                case 0: 
                case 1: {
                    throw StandardException.newException("XCL26.S", Integer.toString(n + 1));
                }
            }
            return genericParameter.getValue();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.checkPosition(n);
            return null;
        }
    }

    public void setParameterAsObject(int n, Object object) throws StandardException {
        UserDataValue userDataValue = (UserDataValue)this.getParameterForSet(n);
        GenericParameter genericParameter = this.parms[n];
        if (object != null) {
            boolean bl;
            ClassNotFoundException classNotFoundException = null;
            try {
                bl = !this.ci.instanceOf(genericParameter.declaredClassName, object);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                classNotFoundException = classNotFoundException2;
                bl = true;
            }
            if (bl) {
                throw StandardException.newException("XCL12.S", classNotFoundException, (Object)ClassInspector.readableClassName(object.getClass()), (Object)genericParameter.declaredClassName);
            }
        }
        userDataValue.setValue(object);
    }

    public boolean allAreSet() {
        block4: for (int i = 0; i < this.parms.length; ++i) {
            GenericParameter genericParameter = this.parms[i];
            if (genericParameter.isSet) continue;
            switch (genericParameter.parameterMode) {
                case 4: {
                    continue block4;
                }
                case 0: 
                case 1: 
                case 2: {
                    return false;
                }
            }
        }
        return true;
    }

    public void transferDataValues(ParameterValueSet parameterValueSet) throws StandardException {
        int n;
        for (int i = n = parameterValueSet.hasReturnOutputParameter() ? 1 : 0; i < this.parms.length; ++i) {
            GenericParameter genericParameter = this.parms[i];
            if (genericParameter.registerOutType != 0) {
                parameterValueSet.registerOutParameter(i, genericParameter.registerOutType, genericParameter.registerOutScale);
            }
            if (!genericParameter.isSet) continue;
            DataValueDescriptor dataValueDescriptor = genericParameter.getValue();
            Object var6_6 = null;
            if (dataValueDescriptor.hasStream()) {
                parameterValueSet.getParameterForSet(i).setValue(dataValueDescriptor.getStream(), -1);
                continue;
            }
            parameterValueSet.getParameterForSet(i).setValue(dataValueDescriptor);
        }
    }

    GenericParameter getGenericParameter(int n) {
        return this.parms[n];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.parms.length; ++i) {
            stringBuffer.append("begin parameter #" + (i + 1) + ": ");
            stringBuffer.append(this.parms[i].toString());
            stringBuffer.append(" :end parameter ");
        }
        return stringBuffer.toString();
    }

    private void checkPosition(int n) throws StandardException {
        if (n < 0 || n >= this.parms.length) {
            if (this.parms.length == 0) {
                throw StandardException.newException("07009");
            }
            throw StandardException.newException("XCL13.S", (Object)String.valueOf(n + 1), (Object)String.valueOf(this.parms.length));
        }
    }

    public ParameterValueSet getClone() {
        return new GenericParameterValueSet(this.parms.length, this);
    }

    public void registerOutParameter(int n, int n2, int n3) throws StandardException {
        this.checkPosition(n);
        Util.checkSupportedRaiseStandard(n2);
        this.parms[n].setOutParameter(n2, n3);
    }

    public void validate() throws StandardException {
        for (int i = 0; i < this.parms.length; ++i) {
            this.parms[i].validate();
        }
    }

    public int getParameterNumber(GenericParameter genericParameter) {
        for (int i = 0; i < this.parms.length; ++i) {
            if (this.parms[i] != genericParameter) continue;
            return i + 1;
        }
        return 0;
    }

    public boolean checkNoDeclaredOutputParameters() {
        boolean bl = false;
        block5: for (int i = 0; i < this.parms.length; ++i) {
            GenericParameter genericParameter = this.parms[i];
            switch (genericParameter.parameterMode) {
                case 1: {
                    continue block5;
                }
                case 2: 
                case 4: {
                    bl = true;
                    continue block5;
                }
                case 0: {
                    genericParameter.parameterMode = 1;
                }
            }
        }
        return bl;
    }

    public short getParameterMode(int n) {
        short s = this.parms[n - 1].parameterMode;
        return s;
    }

    public boolean hasReturnOutputParameter() {
        return this.hasReturnOutputParam;
    }

    public DataValueDescriptor getReturnValueForSet() throws StandardException {
        this.checkPosition(0);
        return this.parms[0].getValue();
    }

    public int getScale(int n) {
        return this.parms[n - 1].getScale();
    }

    public int getPrecision(int n) {
        return this.parms[n - 1].getPrecision();
    }
}

