/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.util.concurrent.LinkedBlockingQueue;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.ZooKeeperCriticalThread;
import org.apache.zookeeper.server.ZooTrace;
import org.apache.zookeeper.server.quorum.ObserverZooKeeperServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObserverRequestProcessor
extends ZooKeeperCriticalThread
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ObserverRequestProcessor.class);
    ObserverZooKeeperServer zks;
    RequestProcessor nextProcessor;
    LinkedBlockingQueue<Request> queuedRequests = new LinkedBlockingQueue();
    boolean finished = false;

    public ObserverRequestProcessor(ObserverZooKeeperServer zks, RequestProcessor nextProcessor) {
        super("ObserverRequestProcessor:" + zks.getServerId(), zks.getZooKeeperServerListener());
        this.zks = zks;
        this.nextProcessor = nextProcessor;
    }

    @Override
    public void run() {
        try {
            while (!this.finished) {
                Request request = this.queuedRequests.take();
                if (LOG.isTraceEnabled()) {
                    ZooTrace.logRequest(LOG, 2L, 'F', request, "");
                }
                if (request != Request.requestOfDeath) {
                    this.nextProcessor.processRequest(request);
                    switch (request.type) {
                        case 9: {
                            this.zks.pendingSyncs.add(request);
                            this.zks.getObserver().request(request);
                            break;
                        }
                        case -11: 
                        case -10: 
                        case 1: 
                        case 2: 
                        case 5: 
                        case 7: 
                        case 14: {
                            this.zks.getObserver().request(request);
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.handleException(this.getName(), e);
        }
        LOG.info("ObserverRequestProcessor exited loop!");
    }

    @Override
    public void processRequest(Request request) {
        if (!this.finished) {
            this.queuedRequests.add(request);
        }
    }

    @Override
    public void shutdown() {
        LOG.info("Shutting down");
        this.finished = true;
        this.queuedRequests.clear();
        this.queuedRequests.add(Request.requestOfDeath);
        this.nextProcessor.shutdown();
    }
}

