/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.element;

import javax.servlet.Filter;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.whiteboard.FilterMapping;
import org.ops4j.pax.web.extender.whiteboard.internal.element.WebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.util.DictionaryUtils;
import org.ops4j.pax.web.extender.whiteboard.internal.util.WebContainerUtils;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

public class FilterWebElement
implements WebElement {
    private FilterMapping filterMapping;

    public FilterWebElement(FilterMapping filterMapping) {
        NullArgumentException.validateNotNull(filterMapping, "Filter mapping");
        this.filterMapping = filterMapping;
    }

    @Override
    public void register(HttpService httpService, HttpContext httpContext) throws Exception {
        if (!WebContainerUtils.isWebContainer(httpService)) {
            throw new UnsupportedOperationException("Internal error: In use HttpService is not an WebContainer (from Pax Web)");
        }
        ((WebContainer)httpService).registerFilter(this.filterMapping.getFilter(), this.filterMapping.getUrlPatterns(), this.filterMapping.getServletNames(), DictionaryUtils.adapt(this.filterMapping.getInitParams()), httpContext);
    }

    @Override
    public void unregister(HttpService httpService, HttpContext httpContext) {
        if (WebContainerUtils.isWebContainer(httpService)) {
            Filter filter = this.filterMapping.getFilter();
            ((WebContainer)httpService).unregisterFilter(filter);
        }
    }

    @Override
    public String getHttpContextId() {
        return this.filterMapping.getHttpContextId();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "mapping=" + this.filterMapping + "}";
    }
}

