/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.netflix.servo.SpectatorContext;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.Gauge;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.SpectatorMonitor;
import com.netflix.servo.tag.TagList;
import com.netflix.servo.util.Throwables;
import java.util.concurrent.Callable;

public final class BasicGauge<T extends Number>
extends AbstractMonitor<T>
implements Gauge<T>,
SpectatorMonitor {
    private final MonitorConfig baseConfig;
    private final Callable<T> function;

    public BasicGauge(MonitorConfig config, Callable<T> function) {
        super(config.withAdditionalTag(DataSourceType.GAUGE));
        this.baseConfig = config;
        this.function = function;
    }

    @Override
    public T getValue(int pollerIndex) {
        try {
            return (T)((Number)this.function.call());
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public void initializeSpectator(TagList tags) {
        SpectatorContext.polledGauge(this.baseConfig).monitorValue((Object)this, m -> ((Number)m.getValue(0)).doubleValue());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BasicGauge)) {
            return false;
        }
        BasicGauge m = (BasicGauge)obj;
        return this.config.equals(m.getConfig()) && this.function.equals(m.function);
    }

    public int hashCode() {
        int result = this.config.hashCode();
        result = 31 * result + this.function.hashCode();
        return result;
    }

    public String toString() {
        return "BasicGauge{config=" + this.config + ", function=" + this.function + '}';
    }
}

