/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.MessageFormatter;
import com.google.javascript.jscomp.SortingErrorManager;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;
import java.io.PrintStream;

public class PrintStreamErrorReportGenerator
implements SortingErrorManager.ErrorReportGenerator {
    private final MessageFormatter formatter;
    private final PrintStream stream;
    private final int summaryDetailLevel;

    public PrintStreamErrorReportGenerator(MessageFormatter formatter, PrintStream stream, int summaryDetailLevel) {
        this.formatter = formatter;
        this.stream = stream;
        this.summaryDetailLevel = summaryDetailLevel;
    }

    @Override
    public void generateReport(SortingErrorManager manager) {
        for (SortingErrorManager.ErrorWithLevel e : manager.getSortedDiagnostics()) {
            this.println(e.level, e.error);
        }
        this.printSummary(manager);
    }

    private void println(CheckLevel level, JSError error) {
        this.stream.println(error.format(level, this.formatter));
    }

    private void printSummary(ErrorManager manager) {
        if (this.summaryDetailLevel >= 3 || this.summaryDetailLevel >= 1 && manager.getErrorCount() + manager.getWarningCount() > 0 || this.summaryDetailLevel >= 2 && manager.getTypedPercent() > 0.0) {
            if (manager.getTypedPercent() > 0.0) {
                this.stream.print(SimpleFormat.format("%d error(s), %d warning(s), %.1f%% typed%n", manager.getErrorCount(), manager.getWarningCount(), manager.getTypedPercent()));
            } else {
                this.stream.print(SimpleFormat.format("%d error(s), %d warning(s)%n", manager.getErrorCount(), manager.getWarningCount()));
            }
        }
    }
}

