/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFunctionCallNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.ILanguageIdentifierNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class MissingConstructorSuperRule
extends LinterRule {
    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.FunctionID, (node, tokenQuery, problems) -> this.checkFunctionNode((IFunctionNode)node, tokenQuery, problems));
        return result;
    }

    private void checkFunctionNode(IFunctionNode functionNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        if (!functionNode.isConstructor()) {
            return;
        }
        if (this.hasSuperCall((IASNode)functionNode.getScopedNode())) {
            return;
        }
        problems.add(new MissingConstructorSuperLinterProblem(functionNode));
    }

    private boolean hasSuperCall(IASNode node) {
        ILanguageIdentifierNode identifierNode;
        IFunctionCallNode functionCallNode;
        IExpressionNode nameNode;
        if (node instanceof IFunctionCallNode && (nameNode = (functionCallNode = (IFunctionCallNode)node).getNameNode()) instanceof ILanguageIdentifierNode && ILanguageIdentifierNode.LanguageIdentifierKind.SUPER.equals((Object)(identifierNode = (ILanguageIdentifierNode)nameNode).getKind())) {
            return true;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            IASNode child = node.getChild(i);
            if (!this.hasSuperCall(child)) continue;
            return true;
        }
        return false;
    }

    public static class MissingConstructorSuperLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Constructor '${functionName}' does not include 'super()' call";
        public String functionName;

        public MissingConstructorSuperLinterProblem(IFunctionNode node) {
            super((ISourceLocation)node.getNameExpressionNode());
            this.functionName = node.getName();
        }
    }
}

