/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IBlockNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IPackageNode;
import org.apache.royale.compiler.tree.as.ITypeNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class EmptyNestedBlockRule
extends LinterRule {
    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.BlockID, (node, tokenQuery, problems) -> this.checkBlockNode((IBlockNode)node, tokenQuery, problems));
        return result;
    }

    private void checkBlockNode(IBlockNode blockNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        if (!this.isNested(blockNode)) {
            return;
        }
        if (!this.isEmptyBlock(blockNode, tokenQuery)) {
            return;
        }
        problems.add(new EmptyNestedBlockLinterProblem(blockNode));
    }

    private boolean isNested(IBlockNode blockNode) {
        IASNode parentNode = blockNode.getParent();
        return parentNode != null && !(parentNode instanceof IPackageNode) && !(parentNode instanceof ITypeNode) && !(parentNode instanceof IFunctionNode);
    }

    private boolean isEmptyBlock(IBlockNode blockNode, TokenQuery tokenQuery) {
        if (blockNode.getChildCount() > 0) {
            return false;
        }
        return tokenQuery.getCommentsInside(blockNode).length <= 0;
    }

    public static class EmptyNestedBlockLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Block must not be empty";

        public EmptyNestedBlockLinterProblem(IBlockNode node) {
            super((ISourceLocation)node);
        }
    }
}

