/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.CoverageInstrumentationPass;
import com.google.javascript.jscomp.CoverageUtil;
import com.google.javascript.jscomp.FileInstrumentationData;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.Map;

@GwtIncompatible(value="FileInstrumentationData")
class CoverageInstrumentationCallback
extends NodeTraversal.AbstractPostOrderCallback {
    private final Map<String, FileInstrumentationData> instrumentationData;
    private final CoverageInstrumentationPass.CoverageReach reach;
    static final String ARRAY_NAME_PREFIX = "JSCompiler_lcov_data_";

    public CoverageInstrumentationCallback(Map<String, FileInstrumentationData> instrumentationData, CoverageInstrumentationPass.CoverageReach reach) {
        this.instrumentationData = instrumentationData;
        this.reach = reach;
    }

    private static String getFileName(NodeTraversal traversal) {
        return traversal.getSourceName();
    }

    private String createArrayName(NodeTraversal traversal) {
        return ARRAY_NAME_PREFIX + CoverageUtil.createIdentifierFromText(CoverageInstrumentationCallback.getFileName(traversal));
    }

    private Node newInstrumentationNode(NodeTraversal traversal, Node node) {
        int lineNumber = node.getLineno();
        String arrayName = this.createArrayName(traversal);
        Node getElemNode = IR.getelem(IR.name(arrayName), IR.number(lineNumber - 1));
        Node exprNode = IR.exprResult(IR.assign(getElemNode, IR.trueNode()));
        String fileName = CoverageInstrumentationCallback.getFileName(traversal);
        if (!this.instrumentationData.containsKey(fileName)) {
            this.instrumentationData.put(fileName, new FileInstrumentationData(fileName, arrayName));
        }
        this.instrumentationData.get(fileName).setLineAsInstrumented(lineNumber);
        return exprNode.useSourceInfoIfMissingFromForTree(node);
    }

    private Node newArrayDeclarationNode(NodeTraversal traversal) {
        return IR.var(IR.name(this.createArrayName(traversal)), IR.arraylit(new Node[0]));
    }

    private Node newHeaderNode(NodeTraversal traversal, Node srcref) {
        String fileName = CoverageInstrumentationCallback.getFileName(traversal);
        String arrayName = this.createArrayName(traversal);
        FileInstrumentationData data = this.instrumentationData.get(fileName);
        Preconditions.checkNotNull(data);
        String objName = "__jscov";
        return IR.block(this.newArrayDeclarationNode(traversal), IR.exprResult(IR.call(IR.getprop(IR.getelem(IR.name(objName), IR.string("executedLines")), "push", new String[0]), IR.name(arrayName))), IR.exprResult(IR.call(IR.getprop(IR.getelem(IR.name(objName), IR.string("instrumentedLines")), "push", new String[0]), IR.string(data.getInstrumentedLinesAsHexString()))), IR.exprResult(IR.call(IR.getprop(IR.getelem(IR.name(objName), IR.string("fileNames")), "push", new String[0]), IR.string(fileName)))).useSourceInfoIfMissingFromForTree(srcref);
    }

    @Override
    public void visit(NodeTraversal traversal, Node node, Node parent) {
        if (node.isScript()) {
            String fileName = CoverageInstrumentationCallback.getFileName(traversal);
            if (this.instrumentationData.get(fileName) != null) {
                node.addChildrenToFront(this.newHeaderNode(traversal, node).removeChildren());
            }
            traversal.reportCodeChange();
            return;
        }
        if (this.reach == CoverageInstrumentationPass.CoverageReach.CONDITIONAL && parent != null && parent.isScript()) {
            return;
        }
        if (node.isFunction() && !NodeUtil.getFunctionBody(node).isBlock()) {
            Node returnValue = NodeUtil.getFunctionBody(node);
            Node body = IR.block(IR.returnNode(returnValue.detach()));
            body.useSourceInfoIfMissingFromForTree(returnValue);
            node.addChildToBack(body);
        }
        if (node.isFunction() || node.isWith() || node.isCase() || node.isDefaultCase() || node.isCatch()) {
            Node codeBlock = node.getLastChild();
            codeBlock.addChildToFront(this.newInstrumentationNode(traversal, node));
            traversal.reportCodeChange();
            return;
        }
        if (node.isTry()) {
            Node firstChild = node.getFirstChild();
            firstChild.addChildToFront(this.newInstrumentationNode(traversal, node));
            traversal.reportCodeChange();
            return;
        }
        if (parent != null && NodeUtil.isStatementBlock(parent)) {
            parent.addChildBefore(this.newInstrumentationNode(traversal, node), node);
            traversal.reportCodeChange();
            return;
        }
    }
}

