/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import org.apache.royale.compiler.config.CompilerDiagnosticsConstants;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.mxml.MXMLDialect;
import org.apache.royale.compiler.internal.parsing.as.ASParser;
import org.apache.royale.compiler.internal.parsing.as.IncludeHandler;
import org.apache.royale.compiler.internal.parsing.as.OffsetLookup;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.scopes.MXMLFileScope;
import org.apache.royale.compiler.internal.semantics.PostProcessStep;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.as.ScopedBlockNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLClassDefinitionNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLFileNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.mxml.IMXMLTagAttributeData;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.mxml.IMXMLTextData;
import org.apache.royale.compiler.mxml.IMXMLUnitData;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.MXMLDualContentProblem;
import org.apache.royale.compiler.problems.UnexpectedExceptionProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.mxml.IMXMLScriptNode;

class MXMLScriptNode
extends MXMLNodeBase
implements IMXMLScriptNode {
    private IASNode[] asNodes;

    MXMLScriptNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLScriptID;
    }

    @Override
    public IASNode getChild(int i) {
        return this.asNodes != null ? this.asNodes[i] : null;
    }

    @Override
    public int getChildCount() {
        return this.asNodes != null ? this.asNodes.length : 0;
    }

    @Override
    public String getName() {
        return "Script";
    }

    @Override
    public IASNode[] getASNodes() {
        if (this.asNodes == null) {
            this.asNodes = new MXMLScriptNode[0];
        }
        return this.asNodes;
    }

    @Override
    protected MXMLNodeBase.MXMLNodeInfo createNodeInfo(MXMLTreeBuilder builder) {
        return new MXMLNodeBase.MXMLNodeInfo(builder);
    }

    @Override
    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        if (attribute.isSpecialAttribute("source")) {
            MXMLClassDefinitionNode classNode = this.getContainingClassNode();
            ASScope classScope = (ASScope)classNode.getClassDefinition().getContainedScope();
            String sourcePath = MXMLScriptNode.resolveSourceAttributePath(builder, attribute, info);
            if (sourcePath != null) {
                String scriptText;
                RoyaleProject project = builder.getProject();
                Workspace workspace = builder.getWorkspace();
                Collection<ICompilerProblem> problems = builder.getProblems();
                if ((CompilerDiagnosticsConstants.diagnostics & 0x100) == 256) {
                    System.out.println("MXMLScriptNode waiting for lock in processTagSpecificAttribute");
                }
                IFileSpecification sourceFileSpec = workspace.getFileSpecification(sourcePath);
                if ((CompilerDiagnosticsConstants.diagnostics & 0x100) == 256) {
                    System.out.println("MXMLScriptNode done with lock in processTagSpecificAttribute");
                }
                if ((scriptText = builder.readExternalFile(attribute, sourcePath)) != null) {
                    IncludeHandler includeHandler = new IncludeHandler(builder.getFileSpecificationGetter());
                    includeHandler.setProjectAndCompilationUnit(project, builder.getCompilationUnit());
                    includeHandler.enterFile(sourcePath);
                    MXMLFileScope fileScope = builder.getFileScope();
                    OffsetLookup offsetLookup = fileScope.getOffsetLookup();
                    assert (offsetLookup != null) : "Expected OffsetLookup on FileScope.";
                    int[] absoluteOffset = offsetLookup.getAbsoluteOffset(sourcePath, 0);
                    ScopedBlockNode fragment = ASParser.parseFragment2(scriptText, sourceFileSpec.getPath(), absoluteOffset[0], 0, 0, problems, workspace, builder.getFileNode(), classScope, project.getProjectConfigVariables(), EnumSet.of(PostProcessStep.CALCULATE_OFFSETS, PostProcessStep.RECONNECT_DEFINITIONS), true, includeHandler);
                    builder.getFileNode().updateIncludeTreeLastModified(includeHandler.getLastModified());
                    int n = fragment.getChildCount();
                    this.asNodes = new IASNode[n];
                    for (int i = 0; i < n; ++i) {
                        IASNode child;
                        this.asNodes[i] = child = fragment.getChild(i);
                        ((NodeBase)child).setParent(this);
                    }
                }
            }
        } else {
            super.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }

    @Override
    protected void processChildNonWhitespaceUnit(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTextData text, MXMLNodeBase.MXMLNodeInfo info) {
        info.hasDualContent = true;
    }

    private MXMLClassDefinitionNode getContainingClassNode() {
        MXMLClassDefinitionNode result = (MXMLClassDefinitionNode)this.getAncestorOfType(MXMLClassDefinitionNode.class);
        assert (result != null);
        return result;
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        super.initializationComplete(builder, tag, info);
        if (info.hasSourceAttribute && info.hasDualContent) {
            MXMLDualContentProblem problem = new MXMLDualContentProblem(tag, tag.getShortName());
            builder.addProblem(problem);
            return;
        }
        MXMLDialect mxmlDialect = builder.getMXMLDialect();
        String sourcePath = tag.getParent().getFileSpecification().getPath();
        MXMLClassDefinitionNode classNode = this.getContainingClassNode();
        ASScope classScope = (ASScope)classNode.getClassDefinition().getContainedScope();
        RoyaleProject project = builder.getProject();
        OffsetLookup offsetLookup = classScope.getFileScope().getOffsetLookup();
        this.setSourcePath(sourcePath);
        try {
            ArrayList<ScopedBlockNode> scriptNodes = new ArrayList<ScopedBlockNode>();
            for (IMXMLUnitData unit = tag.getFirstChildUnit(); unit != null; unit = unit.getNextSiblingUnit()) {
                IMXMLTextData mxmlTextData;
                String text;
                if (!(unit instanceof IMXMLTextData) || mxmlDialect.isWhitespace(text = (mxmlTextData = (IMXMLTextData)unit).getCompilableText())) continue;
                assert (offsetLookup != null) : "Expected OffsetLookup on FileScope.";
                int localOffset = mxmlTextData.getParentUnitData().getAbsoluteEnd();
                int[] absoluteOffsets = offsetLookup.getAbsoluteOffset(sourcePath, localOffset);
                int absoluteOffset = absoluteOffsets[0];
                IncludeHandler includeHandler = IncludeHandler.createForASTBuilding(builder.getFileSpecificationGetter(), sourcePath, localOffset, absoluteOffset);
                EnumSet<PostProcessStep> postProcess = EnumSet.of(PostProcessStep.CALCULATE_OFFSETS, PostProcessStep.RECONNECT_DEFINITIONS);
                ScopedBlockNode node = ASParser.parseInlineScript(builder.getFileNode(), mxmlTextData, builder.getProblems(), classScope, project.getProjectConfigVariables(), includeHandler, postProcess);
                MXMLFileNode filenode = builder.getFileNode();
                filenode.updateIncludeTreeLastModified(includeHandler.getLastModified());
                assert (node != null) : "Expected node from ASParser.getScopesFromInlineScript().";
                scriptNodes.add(node);
            }
            for (ScopedBlockNode script : scriptNodes) {
                int n = script.getChildCount();
                this.asNodes = new IASNode[n];
                for (int i = 0; i < n; ++i) {
                    IASNode child;
                    this.asNodes[i] = child = script.getChild(i);
                    ((NodeBase)child).setParent(this);
                }
            }
        }
        catch (Exception e) {
            builder.addProblem(new UnexpectedExceptionProblem(e));
        }
    }
}

