/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.css;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.apache.royale.compiler.common.SourceLocation;
import org.apache.royale.compiler.css.ICSSNode;
import org.apache.royale.compiler.internal.css.CSSModelTreeType;

class CSSNodeBase
extends SourceLocation
implements ICSSNode {
    private static final int NOT_SET = -1;
    private final CSSModelTreeType type;
    protected final List<ICSSNode> children;
    private static final Function<ICSSNode, String> NODE_TO_TREE_TEXT = new Function<ICSSNode, String>(){

        public String apply(ICSSNode node) {
            return node.toStringTree();
        }
    };

    protected CSSNodeBase(CommonTree tree, TokenStream tokenStream, CSSModelTreeType type) {
        if (tree != null && tokenStream != null) {
            this.setSourceLocation(tree, tokenStream);
        }
        this.type = type;
        this.children = new ArrayList<ICSSNode>();
    }

    private void setSourceLocation(CommonTree tree, TokenStream tokenStream) {
        int tokenStopIndex;
        int line = -1;
        int column = -1;
        int start = -1;
        int stop = -1;
        int tokenStartIndex = tree.getTokenStartIndex();
        if (tokenStartIndex >= 0) {
            CommonToken startToken = (CommonToken)tokenStream.get(tokenStartIndex);
            start = startToken.getStartIndex();
            line = startToken.getLine();
            column = startToken.getCharPositionInLine() + 1;
        }
        if ((tokenStopIndex = tree.getTokenStopIndex()) >= 0) {
            CommonToken stopToken = (CommonToken)tokenStream.get(tokenStopIndex);
            stop = stopToken.getStopIndex() + 1;
        }
        this.setStart(start);
        this.setEnd(stop);
        this.setLine(line);
        this.setColumn(column);
        this.setSourcePath(tokenStream.getSourceName());
    }

    @Override
    public String toStringTree() {
        if (this.children.isEmpty()) {
            return this.type.name();
        }
        return "( " + this.type.name() + " " + Joiner.on((String)" ").skipNulls().join((Iterable)Collections2.transform(this.children, NODE_TO_TREE_TEXT)) + " )";
    }

    @Override
    public int getArity() {
        return this.children.size();
    }

    @Override
    public ICSSNode getNthChild(int index) {
        return this.children.get(index);
    }

    @Override
    public CSSModelTreeType getOperator() {
        return this.type;
    }
}

