/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.swf.debug.DebugModule;
import flash.swf.debug.LineRecord;
import flash.tools.ActionLocation;
import flash.tools.debugger.InProgressException;
import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.Session;
import flash.tools.debugger.SourceFile;
import flash.tools.debugger.SwfInfo;
import flash.tools.debugger.concrete.DManager;
import flash.tools.debugger.concrete.DModule;
import flash.tools.debugger.concrete.LineFunctionContainer;
import flash.tools.debugger.concrete.PlayerSession;
import flash.tools.debugger.concrete.PlayerSessionManager;
import flash.tools.debugger.events.FunctionMetaDataAvailableEvent;
import flash.util.IntMap;
import java.util.Map;

public class DSwfInfo
implements SwfInfo {
    private int m_index;
    private long m_id = 0L;
    private IntMap m_source;
    private String m_path;
    private String m_url;
    private String m_host;
    private int m_port;
    private boolean m_swdLoading;
    private int m_swfSize;
    private int m_swdSize;
    private int m_bpCount;
    private int m_offsetCount;
    private int m_scriptsExpected;
    private int m_minId;
    private int m_maxId;
    private byte[] m_swf;
    private byte[] m_swd;
    private boolean m_unloaded;
    private Map<Long, Integer> m_local2Global;
    private int m_numRefreshes;
    private int m_vmVersion;
    private boolean m_populated;
    private LineFunctionContainer m_container;
    private static final String UNKNOWN = PlayerSessionManager.getLocalizationManager().getLocalizedTextString("unknown");
    DManager m_manager;
    private int m_isolateId = 1;

    public DSwfInfo(int n, int n2) {
        this.m_index = n;
        this.m_source = new IntMap();
        this.m_path = UNKNOWN;
        this.m_url = UNKNOWN;
        this.m_host = UNKNOWN;
        this.m_port = 0;
        this.m_swdLoading = true;
        this.m_scriptsExpected = -1;
        this.m_isolateId = n2;
    }

    @Override
    public String getPath() {
        return this.m_path;
    }

    @Override
    public String getUrl() {
        return this.m_url;
    }

    @Override
    public int getSwfSize() {
        return this.m_swfSize;
    }

    @Override
    public int getSwdSize(Session session) throws InProgressException {
        this.swdLoaded(session);
        return this.m_swdSize;
    }

    @Override
    public boolean isUnloaded() {
        return this.m_unloaded;
    }

    @Override
    public boolean isProcessingComplete() {
        return this.isPopulated();
    }

    @Override
    public boolean containsSource(SourceFile sourceFile) {
        return this.m_source.contains(sourceFile.getId());
    }

    public long getId() {
        return this.m_id;
    }

    public String getHost() {
        return this.m_host;
    }

    public int getPort() {
        return this.m_port;
    }

    public int getSwdSize() {
        return this.m_swdSize;
    }

    public int getRefreshCount() {
        return this.m_numRefreshes;
    }

    public boolean isSwdLoading() {
        return this.m_swdLoading;
    }

    public boolean isPopulated() {
        return this.m_populated;
    }

    public byte[] getSwf() {
        return this.m_swf;
    }

    public byte[] getSwd() {
        return this.m_swd;
    }

    public int getSourceExpectedCount() {
        return this.m_scriptsExpected;
    }

    public int getVmVersion() {
        return this.m_vmVersion;
    }

    public int getSourceCount() {
        return this.m_source.size();
    }

    public int getFirstSourceId() {
        return this.m_minId;
    }

    public int getLastSourceId() {
        return this.m_maxId;
    }

    public void setVmVersion(int n) {
        this.m_vmVersion = n;
    }

    public void setUnloaded() {
        this.m_unloaded = true;
    }

    public void setSwf(byte[] byArray) {
        this.m_swf = byArray;
    }

    public void setSwd(byte[] byArray) {
        this.m_swd = byArray;
    }

    public void setPopulated() {
        this.m_swdLoading = false;
        this.m_populated = true;
    }

    public void setSourceExpectedCount(int n) {
        this.m_scriptsExpected = n;
    }

    public void addSource(int n, DModule dModule) {
        this.m_source.put(n, dModule);
    }

    @Override
    public int getSourceCount(Session session) throws InProgressException {
        if (!this.hasAllSource()) {
            this.swdLoaded(session);
        }
        return this.getSourceCount();
    }

    @Override
    public SourceFile[] getSourceList(Session session) throws InProgressException {
        if (!this.hasAllSource()) {
            this.swdLoaded(session);
        }
        return (SourceFile[])this.m_source.valuesToArray(new SourceFile[this.m_source.size()]);
    }

    void swdLoaded(Session session) throws InProgressException {
        if (this.isSwdLoading() && !this.isUnloaded()) {
            try {
                ((PlayerSession)session).requestSwfInfo(this.m_index, this.m_isolateId);
            }
            catch (NoResponseException noResponseException) {
                // empty catch block
            }
            if (this.m_swdLoading) {
                if (this.getSourceExpectedCount() > -1 && this.m_numRefreshes > 10) {
                    this.setPopulated();
                } else {
                    throw new InProgressException();
                }
            }
        }
    }

    public boolean hasAllSource() {
        boolean bl = false;
        int n = this.getSourceExpectedCount();
        int n2 = this.getSourceCount();
        bl = n == -1 && this.isSwdLoading() ? false : n == n2;
        return bl;
    }

    public void freshen(long l, String string, String string2, String string3, long l2, boolean bl, long l3, long l4, long l5, long l6, long l7, Map<Long, Integer> map, int n, int n2) {
        this.m_id = (int)l;
        this.m_path = string;
        this.m_url = string2;
        this.m_host = string3;
        this.m_port = (int)l2;
        this.m_swfSize = (int)l3;
        this.m_swdSize = (int)l4;
        this.m_bpCount = (int)l5;
        this.m_offsetCount = (int)l6;
        this.m_local2Global = map;
        this.m_minId = l4 > 0L ? n : 0;
        this.m_maxId = l4 > 0L ? n2 : 0;
        this.m_swdLoading = bl;
        ++this.m_numRefreshes;
        if (!bl) {
            this.m_scriptsExpected = (int)l7;
        }
    }

    public ActionLocation locate(int n) {
        return this.m_container.locationLessOrEqualTo(n);
    }

    public ActionLocation locateSourceLineEnd(ActionLocation actionLocation) {
        return this.locateSourceLineEnd(actionLocation, -1);
    }

    public ActionLocation locateSourceLineEnd(ActionLocation actionLocation, int n) {
        ActionLocation actionLocation2 = this.m_container.endOfSourceLine(actionLocation);
        if (n > -1 && actionLocation2.at > n) {
            actionLocation2.at = n;
        }
        return actionLocation2;
    }

    int local2Global(long l) {
        Integer n = this.m_local2Global.get(l);
        if (n != null) {
            l = n.intValue();
        }
        return (int)l;
    }

    public void parseSwfSwd(DManager dManager) {
        this.m_manager = dManager;
        this.m_container = new LineFunctionContainer(this.m_swf, this.m_swd);
        this.m_container.combForLineRecords(this);
        this.setPopulated();
        dManager.addEvent(new FunctionMetaDataAvailableEvent());
        this.m_manager = null;
    }

    public void processLineRecord(ActionLocation actionLocation, LineRecord lineRecord) {
        DModule dModule;
        int n = lineRecord.lineno;
        String string = actionLocation.function == null ? null : actionLocation.function.name;
        DebugModule debugModule = lineRecord.module;
        int n2 = -1;
        if (debugModule != null && actionLocation.at != -1 && (n2 = this.local2Global(debugModule.id)) >= 0 && (dModule = this.m_manager.getSource(n2, 1)) != null) {
            dModule.addLineFunctionInfo(actionLocation.actions.getOffset(actionLocation.at), n, string);
        }
    }

    public String toString() {
        return this.m_path;
    }

    @Override
    public int getIsolateId() {
        return this.m_isolateId;
    }
}

