/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExtBatch;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.common.message.MessageVersion;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.CommitLog;
import org.apache.rocketmq.store.PutMessageContext;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.PutMessageStatus;
import org.apache.rocketmq.store.config.MessageStoreConfig;

public class MessageExtEncoder {
    protected static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private ByteBuf byteBuf;
    private int maxMessageBodySize;
    private int maxMessageSize;
    private final int crc32ReservedLength;
    private MessageStoreConfig messageStoreConfig;

    public MessageExtEncoder(int maxMessageBodySize, MessageStoreConfig messageStoreConfig) {
        this(messageStoreConfig);
    }

    public MessageExtEncoder(MessageStoreConfig messageStoreConfig) {
        UnpooledByteBufAllocator alloc = UnpooledByteBufAllocator.DEFAULT;
        this.messageStoreConfig = messageStoreConfig;
        this.maxMessageBodySize = messageStoreConfig.getMaxMessageSize();
        int maxMessageSize = Integer.MAX_VALUE - this.maxMessageBodySize >= 65536 ? this.maxMessageBodySize + 65536 : Integer.MAX_VALUE;
        this.byteBuf = alloc.directBuffer(maxMessageSize);
        this.maxMessageSize = maxMessageSize;
        this.crc32ReservedLength = messageStoreConfig.isEnabledAppendPropCRC() ? CommitLog.CRC32_RESERVED_LEN : 0;
    }

    public static int calMsgLength(MessageVersion messageVersion, int sysFlag, int bodyLength, int topicLength, int propertiesLength) {
        int bornhostLength = (sysFlag & 0x10) == 0 ? 8 : 20;
        int storehostAddressLength = (sysFlag & 0x20) == 0 ? 8 : 20;
        return 48 + bornhostLength + 8 + storehostAddressLength + 4 + 8 + 4 + Math.max(bodyLength, 0) + messageVersion.getTopicLengthSize() + topicLength + 2 + Math.max(propertiesLength, 0);
    }

    public static int calMsgLengthNoProperties(MessageVersion messageVersion, int sysFlag, int bodyLength, int topicLength) {
        int bornhostLength = (sysFlag & 0x10) == 0 ? 8 : 20;
        int storehostAddressLength = (sysFlag & 0x20) == 0 ? 8 : 20;
        return 48 + bornhostLength + 8 + storehostAddressLength + 4 + 8 + 4 + Math.max(bodyLength, 0) + messageVersion.getTopicLengthSize() + topicLength;
    }

    public PutMessageResult encodeWithoutProperties(MessageExtBrokerInner msgInner) {
        int bodyLength;
        byte[] topicData = msgInner.getTopic().getBytes(MessageDecoder.CHARSET_UTF8);
        int topicLength = topicData.length;
        int n = bodyLength = msgInner.getBody() == null ? 0 : msgInner.getBody().length;
        if (bodyLength > this.maxMessageBodySize) {
            CommitLog.log.warn("message body size exceeded, msg body size: " + bodyLength + ", maxMessageSize: " + this.maxMessageBodySize);
            return new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, null);
        }
        int msgLenNoProperties = MessageExtEncoder.calMsgLengthNoProperties(msgInner.getVersion(), msgInner.getSysFlag(), bodyLength, topicLength);
        this.byteBuf.writeInt(msgLenNoProperties);
        this.byteBuf.writeInt(msgInner.getVersion().getMagicCode());
        this.byteBuf.writeInt(msgInner.getBodyCRC());
        this.byteBuf.writeInt(msgInner.getQueueId());
        this.byteBuf.writeInt(msgInner.getFlag());
        this.byteBuf.writeLong(0L);
        this.byteBuf.writeLong(0L);
        this.byteBuf.writeInt(msgInner.getSysFlag());
        this.byteBuf.writeLong(msgInner.getBornTimestamp());
        ByteBuffer bornHostBytes = msgInner.getBornHostBytes();
        this.byteBuf.writeBytes(bornHostBytes.array());
        this.byteBuf.writeLong(msgInner.getStoreTimestamp());
        ByteBuffer storeHostBytes = msgInner.getStoreHostBytes();
        this.byteBuf.writeBytes(storeHostBytes.array());
        this.byteBuf.writeInt(msgInner.getReconsumeTimes());
        this.byteBuf.writeLong(msgInner.getPreparedTransactionOffset());
        this.byteBuf.writeInt(bodyLength);
        if (bodyLength > 0) {
            this.byteBuf.writeBytes(msgInner.getBody());
        }
        if (MessageVersion.MESSAGE_VERSION_V2.equals((Object)msgInner.getVersion())) {
            this.byteBuf.writeShort((int)((short)topicLength));
        } else {
            this.byteBuf.writeByte((int)((byte)topicLength));
        }
        this.byteBuf.writeBytes(topicData);
        return null;
    }

    public PutMessageResult encode(MessageExtBrokerInner msgInner) {
        boolean needAppendLastPropertySeparator;
        this.byteBuf.clear();
        if (this.messageStoreConfig.isEnableMultiDispatch() && CommitLog.isMultiDispatchMsg(msgInner)) {
            return this.encodeWithoutProperties(msgInner);
        }
        byte[] propertiesData = msgInner.getPropertiesString() == null ? null : msgInner.getPropertiesString().getBytes(MessageDecoder.CHARSET_UTF8);
        int propertiesLength = (propertiesData == null ? 0 : propertiesData.length) + ((needAppendLastPropertySeparator = this.crc32ReservedLength > 0 && propertiesData != null && propertiesData.length > 0 && propertiesData[propertiesData.length - 1] != 2) ? 1 : 0) + this.crc32ReservedLength;
        if (propertiesLength > Short.MAX_VALUE) {
            log.warn("putMessage message properties length too long. length={}", (Object)propertiesLength);
            return new PutMessageResult(PutMessageStatus.PROPERTIES_SIZE_EXCEEDED, null);
        }
        byte[] topicData = msgInner.getTopic().getBytes(MessageDecoder.CHARSET_UTF8);
        int topicLength = topicData.length;
        int bodyLength = msgInner.getBody() == null ? 0 : msgInner.getBody().length;
        int msgLen = MessageExtEncoder.calMsgLength(msgInner.getVersion(), msgInner.getSysFlag(), bodyLength, topicLength, propertiesLength);
        if (bodyLength > this.maxMessageBodySize) {
            CommitLog.log.warn("message body size exceeded, msg total size: " + msgLen + ", msg body size: " + bodyLength + ", maxMessageSize: " + this.maxMessageBodySize);
            return new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, null);
        }
        long queueOffset = msgInner.getQueueOffset();
        if (msgLen > this.maxMessageSize) {
            CommitLog.log.warn("message size exceeded, msg total size: " + msgLen + ", msg body size: " + bodyLength + ", maxMessageSize: " + this.maxMessageSize);
            return new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, null);
        }
        this.byteBuf.writeInt(msgLen);
        this.byteBuf.writeInt(msgInner.getVersion().getMagicCode());
        this.byteBuf.writeInt(msgInner.getBodyCRC());
        this.byteBuf.writeInt(msgInner.getQueueId());
        this.byteBuf.writeInt(msgInner.getFlag());
        this.byteBuf.writeLong(queueOffset);
        this.byteBuf.writeLong(0L);
        this.byteBuf.writeInt(msgInner.getSysFlag());
        this.byteBuf.writeLong(msgInner.getBornTimestamp());
        ByteBuffer bornHostBytes = msgInner.getBornHostBytes();
        this.byteBuf.writeBytes(bornHostBytes.array());
        this.byteBuf.writeLong(msgInner.getStoreTimestamp());
        ByteBuffer storeHostBytes = msgInner.getStoreHostBytes();
        this.byteBuf.writeBytes(storeHostBytes.array());
        this.byteBuf.writeInt(msgInner.getReconsumeTimes());
        this.byteBuf.writeLong(msgInner.getPreparedTransactionOffset());
        this.byteBuf.writeInt(bodyLength);
        if (bodyLength > 0) {
            this.byteBuf.writeBytes(msgInner.getBody());
        }
        if (MessageVersion.MESSAGE_VERSION_V2.equals((Object)msgInner.getVersion())) {
            this.byteBuf.writeShort((int)((short)topicLength));
        } else {
            this.byteBuf.writeByte((int)((byte)topicLength));
        }
        this.byteBuf.writeBytes(topicData);
        this.byteBuf.writeShort((int)((short)propertiesLength));
        if (propertiesLength > this.crc32ReservedLength) {
            this.byteBuf.writeBytes(propertiesData);
        }
        if (needAppendLastPropertySeparator) {
            this.byteBuf.writeByte(2);
        }
        this.byteBuf.writerIndex(this.byteBuf.writerIndex() + this.crc32ReservedLength);
        return null;
    }

    public ByteBuffer encode(MessageExtBatch messageExtBatch, PutMessageContext putMessageContext) {
        this.byteBuf.clear();
        ByteBuffer messagesByteBuff = messageExtBatch.wrap();
        int totalLength = messagesByteBuff.limit();
        if (totalLength > this.maxMessageBodySize) {
            CommitLog.log.warn("message body size exceeded, msg body size: " + totalLength + ", maxMessageSize: " + this.maxMessageBodySize);
            throw new RuntimeException("message body size exceeded");
        }
        String batchPropStr = MessageDecoder.messageProperties2String((Map)messageExtBatch.getProperties());
        byte[] batchPropData = batchPropStr.getBytes(MessageDecoder.CHARSET_UTF8);
        int batchPropDataLen = batchPropData.length;
        if (batchPropDataLen > Short.MAX_VALUE) {
            CommitLog.log.warn("Properties size of messageExtBatch exceeded, properties size: {}, maxSize: {}.", (Object)batchPropDataLen, (Object)Short.MAX_VALUE);
            throw new RuntimeException("Properties size of messageExtBatch exceeded!");
        }
        short batchPropLen = (short)batchPropDataLen;
        int batchSize = 0;
        while (messagesByteBuff.hasRemaining()) {
            ++batchSize;
            messagesByteBuff.getInt();
            messagesByteBuff.getInt();
            messagesByteBuff.getInt();
            int flag = messagesByteBuff.getInt();
            int bodyLen = messagesByteBuff.getInt();
            int bodyPos = messagesByteBuff.position();
            int bodyCrc = UtilAll.crc32((byte[])messagesByteBuff.array(), (int)bodyPos, (int)bodyLen);
            messagesByteBuff.position(bodyPos + bodyLen);
            short propertiesLen = messagesByteBuff.getShort();
            int propertiesPos = messagesByteBuff.position();
            messagesByteBuff.position(propertiesPos + propertiesLen);
            boolean needAppendLastPropertySeparator = propertiesLen > 0 && batchPropLen > 0 && messagesByteBuff.get(messagesByteBuff.position() - 1) != 2;
            byte[] topicData = messageExtBatch.getTopic().getBytes(MessageDecoder.CHARSET_UTF8);
            int topicLength = topicData.length;
            int totalPropLen = needAppendLastPropertySeparator ? propertiesLen + batchPropLen + 1 : propertiesLen + batchPropLen;
            int msgLen = MessageExtEncoder.calMsgLength(messageExtBatch.getVersion(), messageExtBatch.getSysFlag(), bodyLen, topicLength, totalPropLen += this.crc32ReservedLength);
            this.byteBuf.writeInt(msgLen);
            this.byteBuf.writeInt(messageExtBatch.getVersion().getMagicCode());
            this.byteBuf.writeInt(bodyCrc);
            this.byteBuf.writeInt(messageExtBatch.getQueueId());
            this.byteBuf.writeInt(flag);
            this.byteBuf.writeLong(0L);
            this.byteBuf.writeLong(0L);
            this.byteBuf.writeInt(messageExtBatch.getSysFlag());
            this.byteBuf.writeLong(messageExtBatch.getBornTimestamp());
            ByteBuffer bornHostBytes = messageExtBatch.getBornHostBytes();
            this.byteBuf.writeBytes(bornHostBytes.array());
            this.byteBuf.writeLong(messageExtBatch.getStoreTimestamp());
            ByteBuffer storeHostBytes = messageExtBatch.getStoreHostBytes();
            this.byteBuf.writeBytes(storeHostBytes.array());
            this.byteBuf.writeInt(messageExtBatch.getReconsumeTimes());
            this.byteBuf.writeLong(0L);
            this.byteBuf.writeInt(bodyLen);
            if (bodyLen > 0) {
                this.byteBuf.writeBytes(messagesByteBuff.array(), bodyPos, bodyLen);
            }
            if (MessageVersion.MESSAGE_VERSION_V2.equals((Object)messageExtBatch.getVersion())) {
                this.byteBuf.writeShort((int)((short)topicLength));
            } else {
                this.byteBuf.writeByte((int)((byte)topicLength));
            }
            this.byteBuf.writeBytes(topicData);
            this.byteBuf.writeShort((int)((short)totalPropLen));
            if (propertiesLen > 0) {
                this.byteBuf.writeBytes(messagesByteBuff.array(), propertiesPos, (int)propertiesLen);
            }
            if (batchPropLen > 0) {
                if (needAppendLastPropertySeparator) {
                    this.byteBuf.writeByte(2);
                }
                this.byteBuf.writeBytes(batchPropData, 0, (int)batchPropLen);
            }
            this.byteBuf.writerIndex(this.byteBuf.writerIndex() + this.crc32ReservedLength);
        }
        putMessageContext.setBatchSize(batchSize);
        putMessageContext.setPhyPos(new long[batchSize]);
        return this.byteBuf.nioBuffer();
    }

    public ByteBuffer getEncoderBuffer() {
        return this.byteBuf.nioBuffer(0, this.byteBuf.capacity());
    }

    public int getMaxMessageBodySize() {
        return this.maxMessageBodySize;
    }

    public void updateEncoderBufferCapacity(int newMaxMessageBodySize) {
        this.maxMessageBodySize = newMaxMessageBodySize;
        this.maxMessageSize = Integer.MAX_VALUE - newMaxMessageBodySize >= 65536 ? this.maxMessageBodySize + 65536 : Integer.MAX_VALUE;
        this.byteBuf.capacity(this.maxMessageSize);
    }

    static class PutMessageThreadLocal {
        private final MessageExtEncoder encoder;
        private final StringBuilder keyBuilder;

        PutMessageThreadLocal(MessageStoreConfig messageStoreConfig) {
            this.encoder = new MessageExtEncoder(messageStoreConfig);
            this.keyBuilder = new StringBuilder();
        }

        public MessageExtEncoder getEncoder() {
            return this.encoder;
        }

        public StringBuilder getKeyBuilder() {
            return this.keyBuilder;
        }
    }
}

