/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.remoting;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import java.security.cert.CertificateException;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.common.ProxyException;
import org.apache.rocketmq.proxy.common.ProxyExceptionCode;
import org.apache.rocketmq.proxy.remoting.MultiProtocolTlsHelper;
import org.apache.rocketmq.proxy.remoting.protocol.ProtocolNegotiationHandler;
import org.apache.rocketmq.proxy.remoting.protocol.http2proxy.Http2ProtocolProxyHandler;
import org.apache.rocketmq.proxy.remoting.protocol.remoting.RemotingProtocolHandler;
import org.apache.rocketmq.remoting.ChannelEventListener;
import org.apache.rocketmq.remoting.common.TlsMode;
import org.apache.rocketmq.remoting.netty.NettyRemotingServer;
import org.apache.rocketmq.remoting.netty.NettyServerConfig;
import org.apache.rocketmq.remoting.netty.TlsSystemConfig;

public class MultiProtocolRemotingServer
extends NettyRemotingServer {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    private final NettyServerConfig nettyServerConfig;
    private final RemotingProtocolHandler remotingProtocolHandler;
    private final Http2ProtocolProxyHandler http2ProtocolProxyHandler;

    public MultiProtocolRemotingServer(NettyServerConfig nettyServerConfig, ChannelEventListener channelEventListener) {
        super(nettyServerConfig, channelEventListener);
        this.nettyServerConfig = nettyServerConfig;
        this.remotingProtocolHandler = new RemotingProtocolHandler(() -> ((MultiProtocolRemotingServer)this).getEncoder(), () -> ((MultiProtocolRemotingServer)this).getDistributionHandler(), () -> ((MultiProtocolRemotingServer)this).getConnectionManageHandler(), () -> ((MultiProtocolRemotingServer)this).getServerHandler());
        this.http2ProtocolProxyHandler = new Http2ProtocolProxyHandler();
    }

    public void loadSslContext() {
        TlsMode tlsMode = TlsSystemConfig.tlsMode;
        log.info("Server is running in TLS {} mode", (Object)tlsMode.getName());
        if (tlsMode != TlsMode.DISABLED) {
            try {
                this.sslContext = MultiProtocolTlsHelper.buildSslContext();
                log.info("SSLContext created for server");
            }
            catch (IOException | CertificateException e) {
                throw new ProxyException(ProxyExceptionCode.INTERNAL_SERVER_ERROR, "Failed to create SSLContext for server", e);
            }
        }
    }

    protected ChannelPipeline configChannel(SocketChannel ch) {
        return ch.pipeline().addLast((EventExecutorGroup)this.getDefaultEventExecutorGroup(), "handshakeHandler", (ChannelHandler)new NettyRemotingServer.HandshakeHandler((NettyRemotingServer)this)).addLast((EventExecutorGroup)this.getDefaultEventExecutorGroup(), new ChannelHandler[]{new IdleStateHandler(0, 0, this.nettyServerConfig.getServerChannelMaxIdleTimeSeconds()), new ProtocolNegotiationHandler(this.remotingProtocolHandler).addProtocolHandler(this.http2ProtocolProxyHandler)});
    }
}

