/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.plugin;

import java.io.IOException;
import java.lang.reflect.Constructor;
import org.apache.rocketmq.broker.plugin.MessageStorePluginContext;
import org.apache.rocketmq.store.MessageStore;

public final class MessageStoreFactory {
    public static MessageStore build(MessageStorePluginContext context, MessageStore messageStore) throws IOException {
        String plugin = context.getBrokerConfig().getMessageStorePlugIn();
        if (plugin != null && plugin.trim().length() != 0) {
            String[] pluginClasses = plugin.split(",");
            for (int i = pluginClasses.length - 1; i >= 0; --i) {
                String pluginClass = pluginClasses[i];
                try {
                    Class<?> clazz = Class.forName(pluginClass);
                    Constructor<?> construct = clazz.getConstructor(MessageStorePluginContext.class, MessageStore.class);
                    messageStore = (MessageStore)construct.newInstance(context, messageStore);
                    continue;
                }
                catch (Throwable e) {
                    throw new RuntimeException(String.format("Initialize plugin's class %s not found!", pluginClass), e);
                }
            }
        }
        return messageStore;
    }
}

