/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.MethodDelegate;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.codec.Decoder;
import org.apache.qpid.transport.codec.Encoder;

public final class ConnectionTuneOk
extends Method {
    public static final int TYPE = 262;
    private short packing_flags = 0;
    private int channelMax;
    private int maxFrameSize;
    private int heartbeat;

    @Override
    public final int getStructType() {
        return 262;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 0;
    }

    @Override
    public final boolean isConnectionControl() {
        return true;
    }

    public ConnectionTuneOk() {
    }

    public ConnectionTuneOk(int channelMax, int maxFrameSize, int heartbeat, Option ... _options) {
        this.setChannelMax(channelMax);
        this.setMaxFrameSize(maxFrameSize);
        this.setHeartbeat(heartbeat);
        block6: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case SYNC: {
                    this.setSync(true);
                    continue block6;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block6;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block6;
                }
                case NONE: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.connectionTuneOk(context, this);
    }

    public final boolean hasChannelMax() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final ConnectionTuneOk clearChannelMax() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.channelMax = 0;
        this.setDirty(true);
        return this;
    }

    public final int getChannelMax() {
        return this.channelMax;
    }

    public final ConnectionTuneOk setChannelMax(int value) {
        this.channelMax = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.setDirty(true);
        return this;
    }

    public final ConnectionTuneOk channelMax(int value) {
        return this.setChannelMax(value);
    }

    public final boolean hasMaxFrameSize() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final ConnectionTuneOk clearMaxFrameSize() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.maxFrameSize = 0;
        this.setDirty(true);
        return this;
    }

    public final int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public final ConnectionTuneOk setMaxFrameSize(int value) {
        this.maxFrameSize = value;
        this.packing_flags = (short)(this.packing_flags | 0x200);
        this.setDirty(true);
        return this;
    }

    public final ConnectionTuneOk maxFrameSize(int value) {
        return this.setMaxFrameSize(value);
    }

    public final boolean hasHeartbeat() {
        return (this.packing_flags & 0x400) != 0;
    }

    public final ConnectionTuneOk clearHeartbeat() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFBFF);
        this.heartbeat = 0;
        this.setDirty(true);
        return this;
    }

    public final int getHeartbeat() {
        return this.heartbeat;
    }

    public final ConnectionTuneOk setHeartbeat(int value) {
        this.heartbeat = value;
        this.packing_flags = (short)(this.packing_flags | 0x400);
        this.setDirty(true);
        return this;
    }

    public final ConnectionTuneOk heartbeat(int value) {
        return this.setHeartbeat(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeUint16(this.channelMax);
        }
        if ((this.packing_flags & 0x200) != 0) {
            enc.writeUint16(this.maxFrameSize);
        }
        if ((this.packing_flags & 0x400) != 0) {
            enc.writeUint16(this.heartbeat);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.channelMax = dec.readUint16();
        }
        if ((this.packing_flags & 0x200) != 0) {
            this.maxFrameSize = dec.readUint16();
        }
        if ((this.packing_flags & 0x400) != 0) {
            this.heartbeat = dec.readUint16();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("channelMax", this.getChannelMax());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("maxFrameSize", this.getMaxFrameSize());
        }
        if ((this.packing_flags & 0x400) != 0) {
            result.put("heartbeat", this.getHeartbeat());
        }
        return result;
    }
}

