/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.ProcessingInstruction;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.w3c.domts.DOMTest.load;


/**
 * The "importNode(importedNode,deep)" method for a
 * Document should import the given importedNode into that Document.
 * The importedNode is of type Processing Instruction.
 * Create a processing instruction with target as "target1" and data as "data1"
 * in a different document. Invoke method importNode(importedNode,deep) on this document.
 * Method should return a processing instruction whose target and data match the given
 * parameters. The returned PI should belong to this document whose systemId is "staff.dtd".
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#Core-Document-importNode">http://www.w3.org/TR/DOM-Level-2-Core/core#Core-Document-importNode</a>
 */
public class importNode14 {
    @Test
    void testRun() throws Throwable {
        Document doc = load("staffNS", true);
        Document aNewDoc = load("staffNS", true);
        ProcessingInstruction pi = aNewDoc.createProcessingInstruction("target1", "data1");
        ProcessingInstruction aNode = (ProcessingInstruction) doc.importNode(pi, false);
        // TODO: add this if ever implemented
        // DocumentType docType = ownerDocument.getDoctype();
        // String system = docType.getSystemId();
        // assertURIEquals("systemId", null, null, null, "staffNS.dtd", null, null, null, null, system);
        String target = aNode.getTarget();
        assertEquals("target1", target, "piTarget");
        String data = aNode.getData();
        assertEquals("data1", data, "piData");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/importNode14";
    }

}
