/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.util.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class Reflection {
    private static final Object[][] NATIVE_CODES = new Object[][]{{Byte.TYPE, "byte", "B"}, {Character.TYPE, "char", "C"}, {Double.TYPE, "double", "D"}, {Float.TYPE, "float", "F"}, {Integer.TYPE, "int", "I"}, {Long.TYPE, "long", "J"}, {Short.TYPE, "short", "S"}, {Boolean.TYPE, "boolean", "Z"}, {Void.TYPE, "void", "V"}};
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_MAP = new HashMap();

    public static Class<?> primitiveToWrapper(Class<?> cls) {
        Class<?> convertedClass = cls;
        if (cls != null && cls.isPrimitive()) {
            convertedClass = PRIMITIVE_WRAPPER_MAP.get(cls);
        }
        return convertedClass;
    }

    public static Class<?> wrapperToPrimitive(Class<?> cls) {
        for (Map.Entry<Class<?>, Class<?>> primitiveEntry : PRIMITIVE_WRAPPER_MAP.entrySet()) {
            if (!primitiveEntry.getValue().equals(cls)) continue;
            return primitiveEntry.getKey();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getAnnotationValue(Annotation annotation, String name) throws IllegalAccessException, InvocationTargetException {
        Method valueMethod;
        try {
            valueMethod = annotation.annotationType().getDeclaredMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        boolean mustUnset = Reflection.setAccessible(valueMethod, true);
        try {
            Object object = valueMethod.invoke((Object)annotation, new Object[0]);
            return object;
        }
        finally {
            if (mustUnset) {
                Reflection.setAccessible(valueMethod, false);
            }
        }
    }

    public static ClassLoader getClassLoader(Class<?> clazz) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl == null ? clazz.getClassLoader() : cl;
    }

    public static Class<?> toClass(String className) throws ClassNotFoundException {
        ClassLoader cl = Reflection.getClassLoader(Reflection.class);
        return Reflection.toClass(className, cl);
    }

    public static Class toClass(String className, ClassLoader loader) throws ClassNotFoundException {
        return Reflection.toClass(className, false, loader);
    }

    public static Class toClass(String className, boolean resolve, ClassLoader loader) throws ClassNotFoundException {
        if (className == null) {
            throw new NullPointerException("className == null");
        }
        int dims = 0;
        while (className.endsWith("[]")) {
            ++dims;
            className = className.substring(0, className.length() - 2);
        }
        boolean primitive = false;
        if (className.indexOf(46) == -1) {
            for (int i = 0; !primitive && i < NATIVE_CODES.length; ++i) {
                if (!NATIVE_CODES[i][1].equals(className)) continue;
                if (dims == 0) {
                    return (Class)NATIVE_CODES[i][0];
                }
                className = (String)NATIVE_CODES[i][2];
                primitive = true;
            }
        }
        if (dims > 0) {
            StringBuilder buf = new StringBuilder(className.length() + dims + 2);
            for (int i = 0; i < dims; ++i) {
                buf.append('[');
            }
            if (!primitive) {
                buf.append('L');
            }
            buf.append(className);
            if (!primitive) {
                buf.append(';');
            }
            className = buf.toString();
        }
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        return Class.forName(className, resolve, loader);
    }

    public static String getProperty(String name) {
        return System.getProperty(name);
    }

    public static Field getDeclaredField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static Field[] getDeclaredFields(Class<?> clazz) {
        return clazz.getDeclaredFields();
    }

    public static <T> Constructor<T> getDeclaredConstructor(Class<T> clazz, Class<?> ... parameters) {
        try {
            return clazz.getDeclaredConstructor(parameters);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameters) {
        try {
            return clazz.getDeclaredMethod(name, parameters);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        return clazz.getDeclaredMethods();
    }

    public static Constructor<?>[] getDeclaredConstructors(Class<?> clazz) {
        return clazz.getDeclaredConstructors();
    }

    public static Method getPublicMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static <T> T newInstance(Class<T> cls) {
        try {
            return cls.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot instantiate : " + cls, ex);
        }
    }

    public static boolean setAccessible(AccessibleObject o, boolean accessible) {
        if (o == null || o.isAccessible() == accessible) {
            return false;
        }
        if (!accessible && System.getSecurityManager() == null) {
            return false;
        }
        Member m = (Member)((Object)o);
        if (Modifier.isPublic(m.getModifiers()) && Modifier.isPublic(m.getDeclaringClass().getModifiers())) {
            return false;
        }
        o.setAccessible(accessible);
        return true;
    }

    static {
        PRIMITIVE_WRAPPER_MAP.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_WRAPPER_MAP.put(Byte.TYPE, Byte.class);
        PRIMITIVE_WRAPPER_MAP.put(Character.TYPE, Character.class);
        PRIMITIVE_WRAPPER_MAP.put(Short.TYPE, Short.class);
        PRIMITIVE_WRAPPER_MAP.put(Integer.TYPE, Integer.class);
        PRIMITIVE_WRAPPER_MAP.put(Long.TYPE, Long.class);
        PRIMITIVE_WRAPPER_MAP.put(Double.TYPE, Double.class);
        PRIMITIVE_WRAPPER_MAP.put(Float.TYPE, Float.class);
        PRIMITIVE_WRAPPER_MAP.put(Void.TYPE, Void.TYPE);
    }
}

