/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotationCollectors;
import org.springframework.core.annotation.MergedAnnotationPredicates;
import org.springframework.core.annotation.MergedAnnotationSelectors;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;

public interface AnnotatedTypeMetadata {
    public MergedAnnotations getAnnotations();

    default public boolean isAnnotated(String annotationName) {
        return this.getAnnotations().isPresent(annotationName);
    }

    @Nullable
    default public Map<String, Object> getAnnotationAttributes(String annotationName) {
        return this.getAnnotationAttributes(annotationName, false);
    }

    @Nullable
    default public Map<String, Object> getAnnotationAttributes(String annotationName, boolean classValuesAsString) {
        MergedAnnotation annotation = this.getAnnotations().get(annotationName, null, MergedAnnotationSelectors.firstDirectlyDeclared());
        if (!annotation.isPresent()) {
            return null;
        }
        return annotation.asAnnotationAttributes(MergedAnnotation.Adapt.values(classValuesAsString, true));
    }

    @Nullable
    default public MultiValueMap<String, Object> getAllAnnotationAttributes(String annotationName) {
        return this.getAllAnnotationAttributes(annotationName, false);
    }

    @Nullable
    default public MultiValueMap<String, Object> getAllAnnotationAttributes(String annotationName, boolean classValuesAsString) {
        MergedAnnotation.Adapt[] adaptations = MergedAnnotation.Adapt.values(classValuesAsString, true);
        return this.getAnnotations().stream(annotationName).filter(MergedAnnotationPredicates.unique(MergedAnnotation::getMetaTypes)).map(MergedAnnotation::withNonMergedAttributes).collect(MergedAnnotationCollectors.toMultiValueMap(map -> map.isEmpty() ? null : map, adaptations));
    }

    default public Set<AnnotationAttributes> getMergedRepeatableAnnotationAttributes(Class<? extends Annotation> annotationType, Class<? extends Annotation> containerType, boolean classValuesAsString) {
        return this.getMergedRepeatableAnnotationAttributes(annotationType, containerType, classValuesAsString, false);
    }

    default public Set<AnnotationAttributes> getMergedRepeatableAnnotationAttributes(Class<? extends Annotation> annotationType, Class<? extends Annotation> containerType, boolean classValuesAsString, boolean sortByReversedMetaDistance) {
        Stream<MergedAnnotation<Object>> stream = this.getAnnotations().stream().filter(MergedAnnotationPredicates.typeIn(containerType, annotationType));
        if (sortByReversedMetaDistance) {
            stream = stream.sorted(AnnotatedTypeMetadata.reversedMetaDistance());
        }
        MergedAnnotation.Adapt[] adaptations = MergedAnnotation.Adapt.values(false, true);
        return stream.map(annotation -> annotation.asAnnotationAttributes(adaptations)).flatMap(attributes -> {
            if (containerType.equals(attributes.annotationType())) {
                return Stream.of(attributes.getAnnotationArray("value"));
            }
            return Stream.of(attributes);
        }).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static Comparator<MergedAnnotation<Annotation>> reversedMetaDistance() {
        return Comparator.comparingInt(MergedAnnotation::getDistance).reversed();
    }
}

