/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.access.data;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.apache.olingo.odata2.api.commons.InlineCount;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataBadRequestException;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.api.uri.info.DeleteUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityLinkUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetLinksUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetFunctionImportUriInfo;
import org.apache.olingo.odata2.api.uri.info.PostUriInfo;
import org.apache.olingo.odata2.api.uri.info.PutMergePatchUriInfo;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAContext;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPATombstoneContext;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPATombstoneEntityListener;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPATransaction;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAFunction;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAMethodContext;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAPaging;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAProcessor;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContextType;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmMapping;
import org.apache.olingo.odata2.jpa.processor.core.ODataEntityParser;
import org.apache.olingo.odata2.jpa.processor.core.access.data.JPAEntity;
import org.apache.olingo.odata2.jpa.processor.core.access.data.JPALink;
import org.apache.olingo.odata2.jpa.processor.core.access.data.JPAPage;
import org.apache.olingo.odata2.jpa.processor.core.access.data.JPAQueryBuilder;

public class JPAProcessorImpl
implements JPAProcessor {
    private static final String DELTATOKEN = "!deltatoken";
    ODataJPAContext oDataJPAContext;
    EntityManager em;

    public JPAProcessorImpl(ODataJPAContext oDataJPAContext) {
        this.oDataJPAContext = oDataJPAContext;
        this.em = oDataJPAContext.getEntityManager();
    }

    public List<Object> process(GetFunctionImportUriInfo uriParserResultView) throws ODataJPAModelException, ODataJPARuntimeException {
        JPAMethodContext jpaMethodContext = JPAMethodContext.createBuilder((JPQLContextType)JPQLContextType.FUNCTION, (Object)uriParserResultView).build();
        ArrayList<Object> resultObj = null;
        try {
            JPAFunction jpaFunction = (JPAFunction)jpaMethodContext.getJPAFunctionList().get(0);
            Method method = jpaFunction.getFunction();
            Object[] args = jpaFunction.getArguments();
            if (uriParserResultView.getFunctionImport().getReturnType().getMultiplicity().equals((Object)EdmMultiplicity.MANY)) {
                resultObj = (List)method.invoke(jpaMethodContext.getEnclosingObject(), args);
            } else {
                resultObj = new ArrayList();
                Object result = method.invoke(jpaMethodContext.getEnclosingObject(), args);
                resultObj.add(result);
            }
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getTargetException().getMessage()}), (Throwable)e.getTargetException());
        }
        return resultObj;
    }

    public List<Object> process(GetEntitySetUriInfo uriParserResultView) throws ODataJPAModelException, ODataJPARuntimeException {
        boolean hasNoAllPages;
        List<Object> result = null;
        if (uriParserResultView.getFunctionImport() != null) {
            return this.process((GetFunctionImportUriInfo)uriParserResultView);
        }
        InlineCount inlineCount = uriParserResultView.getInlineCount();
        Integer top = uriParserResultView.getTop() == null ? 1 : uriParserResultView.getTop();
        boolean bl = inlineCount == null ? true : (hasNoAllPages = !inlineCount.equals((Object)InlineCount.ALLPAGES));
        if (top == 0 && hasNoAllPages) {
            return new ArrayList<Object>();
        }
        try {
            JPAEdmMapping mapping = (JPAEdmMapping)uriParserResultView.getTargetEntitySet().getEntityType().getMapping();
            JPAQueryBuilder queryBuilder = new JPAQueryBuilder(this.oDataJPAContext);
            JPAQueryBuilder.JPAQueryInfo queryInfo = queryBuilder.build(uriParserResultView);
            Query query = queryInfo.getQuery();
            ODataJPATombstoneEntityListener listener = queryBuilder.getODataJPATombstoneEntityListener((UriInfo)uriParserResultView);
            Map customQueryOptions = uriParserResultView.getCustomQueryOptions();
            String deltaToken = null;
            if (customQueryOptions != null) {
                deltaToken = (String)uriParserResultView.getCustomQueryOptions().get(DELTATOKEN);
            }
            if (deltaToken != null) {
                ODataJPATombstoneContext.setDeltaToken(deltaToken);
            }
            if (listener != null && !queryInfo.isTombstoneQuery() && listener.isTombstoneSupported()) {
                query.getResultList();
                List deltaResult = ODataJPATombstoneContext.getDeltaResult((String)((EdmMapping)mapping).getInternalName());
                result = this.handlePaging(deltaResult, uriParserResultView);
            } else {
                result = this.handlePaging(query, uriParserResultView);
            }
            if (listener != null && listener.isTombstoneSupported()) {
                ODataJPATombstoneContext.setDeltaToken((String)listener.generateDeltaToken(result, query));
            }
            if (InlineCount.ALLPAGES.equals((Object)uriParserResultView.getInlineCount())) {
                queryBuilder.getCount(uriParserResultView);
            }
            return result == null ? new ArrayList() : result;
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.ERROR_JPQL_QUERY_CREATE, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.ERROR_JPQL_QUERY_CREATE, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.ERROR_JPQL_QUERY_CREATE, (Throwable)e);
        }
    }

    public <T> Object process(GetEntityUriInfo uriParserResultView) throws ODataJPAModelException, ODataJPARuntimeException {
        return this.readEntity(new JPAQueryBuilder(this.oDataJPAContext).build(uriParserResultView));
    }

    public long process(GetEntitySetCountUriInfo resultsView) throws ODataJPAModelException, ODataJPARuntimeException {
        JPAQueryBuilder queryBuilder = new JPAQueryBuilder(this.oDataJPAContext);
        Query query = queryBuilder.build(resultsView);
        List resultList = query.getResultList();
        if (resultList != null && resultList.size() == 1) {
            return Long.valueOf(resultList.get(0).toString());
        }
        return 0L;
    }

    public long process(GetEntityCountUriInfo resultsView) throws ODataJPAModelException, ODataJPARuntimeException {
        JPAQueryBuilder queryBuilder = new JPAQueryBuilder(this.oDataJPAContext);
        Query query = queryBuilder.build(resultsView);
        List resultList = query.getResultList();
        if (resultList != null && resultList.size() == 1) {
            return Long.valueOf(resultList.get(0).toString());
        }
        return 0L;
    }

    public Object process(PostUriInfo createView, InputStream content, String requestedContentType) throws ODataJPAModelException, ODataJPARuntimeException {
        return this.processCreate(createView, content, null, requestedContentType);
    }

    public Object process(PostUriInfo createView, Map<String, Object> content) throws ODataJPAModelException, ODataJPARuntimeException {
        return this.processCreate(createView, null, content, null);
    }

    public Object process(PutMergePatchUriInfo updateView, InputStream content, String requestContentType) throws ODataJPAModelException, ODataJPARuntimeException {
        return this.processUpdate(updateView, content, null, requestContentType);
    }

    public Object process(PutMergePatchUriInfo updateView, Map<String, Object> content) throws ODataJPAModelException, ODataJPARuntimeException {
        return this.processUpdate(updateView, null, content, null);
    }

    public Object process(DeleteUriInfo uriParserResultView, String contentType) throws ODataJPAModelException, ODataJPARuntimeException {
        if (uriParserResultView instanceof DeleteUriInfo && ((UriInfo)uriParserResultView).isLinks()) {
            return this.deleteLink(uriParserResultView);
        }
        Object selectedObject = this.readEntity(new JPAQueryBuilder(this.oDataJPAContext).build(uriParserResultView));
        if (selectedObject != null) {
            try {
                boolean isLocalTransaction = this.setTransaction();
                this.em.remove(selectedObject);
                this.em.flush();
                if (isLocalTransaction) {
                    this.oDataJPAContext.getODataJPATransaction().commit();
                }
            }
            catch (PersistenceException e) {
                this.em.getTransaction().rollback();
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.ERROR_JPQL_DELETE_REQUEST, (Throwable)e);
            }
        }
        return selectedObject;
    }

    public Object process(GetEntityLinkUriInfo uriParserResultView) throws ODataJPAModelException, ODataJPARuntimeException {
        return this.process((GetEntityUriInfo)uriParserResultView);
    }

    public List<Object> process(GetEntitySetLinksUriInfo uriParserResultView) throws ODataJPAModelException, ODataJPARuntimeException {
        return this.process((GetEntitySetUriInfo)uriParserResultView);
    }

    public void process(PostUriInfo uriInfo, InputStream content, String requestContentType, String contentType) throws ODataJPARuntimeException, ODataJPAModelException {
        JPALink link = new JPALink(this.oDataJPAContext);
        link.create(uriInfo, content, requestContentType, contentType);
        link.save();
    }

    public void process(PutMergePatchUriInfo putUriInfo, InputStream content, String requestContentType, String contentType) throws ODataJPARuntimeException, ODataJPAModelException {
        JPALink link = new JPALink(this.oDataJPAContext);
        link.update(putUriInfo, content, requestContentType, contentType);
        link.save();
    }

    private Object readEntity(Query query) throws ODataJPARuntimeException {
        Object selectedObject = null;
        List resultList = query.getResultList();
        if (!resultList.isEmpty()) {
            selectedObject = resultList.get(0);
        }
        return selectedObject;
    }

    private Object processCreate(PostUriInfo createView, InputStream content, Map<String, Object> properties, String requestedContentType) throws ODataJPAModelException, ODataJPARuntimeException {
        try {
            EdmEntitySet oDataEntitySet = createView.getTargetEntitySet();
            EdmEntityType oDataEntityType = oDataEntitySet.getEntityType();
            JPAEntity virtualJPAEntity = new JPAEntity(oDataEntityType, oDataEntitySet, this.oDataJPAContext);
            Object jpaEntity = null;
            if (content != null) {
                ODataEntityParser oDataEntityParser = new ODataEntityParser(this.oDataJPAContext);
                ODataEntry oDataEntry = oDataEntityParser.parseEntry(oDataEntitySet, content, requestedContentType, false);
                virtualJPAEntity.create(oDataEntry);
            } else if (properties != null) {
                virtualJPAEntity.create(properties);
            } else {
                return null;
            }
            boolean isLocalTransaction = this.setTransaction();
            jpaEntity = virtualJPAEntity.getJPAEntity();
            this.em.persist(jpaEntity);
            if (this.em.contains(jpaEntity)) {
                if (isLocalTransaction) {
                    this.oDataJPAContext.getODataJPATransaction().commit();
                }
                return jpaEntity;
            }
        }
        catch (ODataBadRequestException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.ERROR_JPQL_QUERY_CREATE, (Throwable)e);
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.ERROR_JPQL_QUERY_CREATE, (Throwable)e);
        }
        return null;
    }

    private <T> Object processUpdate(PutMergePatchUriInfo updateView, InputStream content, Map<String, Object> properties, String requestContentType) throws ODataJPAModelException, ODataJPARuntimeException {
        Object jpaEntity = null;
        boolean isLocalTransaction = false;
        try {
            isLocalTransaction = this.setTransaction();
            jpaEntity = this.readEntity(new JPAQueryBuilder(this.oDataJPAContext).build(updateView));
            if (jpaEntity == null) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.RESOURCE_NOT_FOUND, null);
            }
            EdmEntitySet oDataEntitySet = updateView.getTargetEntitySet();
            EdmEntityType oDataEntityType = oDataEntitySet.getEntityType();
            JPAEntity virtualJPAEntity = new JPAEntity(oDataEntityType, oDataEntitySet, this.oDataJPAContext);
            virtualJPAEntity.setJPAEntity(jpaEntity);
            if (content != null) {
                ODataEntityParser oDataEntityParser = new ODataEntityParser(this.oDataJPAContext);
                ODataEntry oDataEntry = oDataEntityParser.parseEntry(oDataEntitySet, content, requestContentType, false);
                virtualJPAEntity.update(oDataEntry);
            } else if (properties != null) {
                virtualJPAEntity.update(properties);
            } else {
                Object var10_14 = null;
                return var10_14;
            }
            this.em.flush();
            if (isLocalTransaction) {
                this.oDataJPAContext.getODataJPATransaction().commit();
            }
        }
        catch (ODataBadRequestException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.ERROR_JPQL_QUERY_CREATE, (Throwable)e);
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.ERROR_JPQL_QUERY_CREATE, (Throwable)e);
        }
        catch (PersistenceException e) {
            this.em.getTransaction().rollback();
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.ERROR_JPQL_QUERY_CREATE, (Throwable)e);
        }
        finally {
            if (isLocalTransaction && this.oDataJPAContext.getODataJPATransaction().isActive()) {
                this.oDataJPAContext.getODataJPATransaction().rollback();
            }
        }
        return jpaEntity;
    }

    private Object deleteLink(DeleteUriInfo uriParserResultView) throws ODataJPARuntimeException {
        JPALink link = new JPALink(this.oDataJPAContext);
        link.delete(uriParserResultView);
        link.save();
        return link.getTargetJPAEntity();
    }

    private List<Object> handlePaging(List<Object> result, GetEntitySetUriInfo uriParserResultView) {
        if (result == null) {
            return null;
        }
        JPAPage.JPAPageBuilder pageBuilder = new JPAPage.JPAPageBuilder();
        pageBuilder.pageSize(this.oDataJPAContext.getPageSize()).entities(result).skipToken(uriParserResultView.getSkipToken());
        if (uriParserResultView.getSkip() != null) {
            pageBuilder.skip(uriParserResultView.getSkip());
        }
        if (uriParserResultView.getTop() != null) {
            pageBuilder.top(uriParserResultView.getTop());
        }
        JPAPage page = pageBuilder.build();
        this.oDataJPAContext.setPaging((JPAPaging)page);
        return page.getPagedEntities();
    }

    private List<Object> handlePaging(Query query, GetEntitySetUriInfo uriParserResultView) {
        JPAPage.JPAPageBuilder pageBuilder = new JPAPage.JPAPageBuilder();
        pageBuilder.pageSize(this.oDataJPAContext.getPageSize()).query(query).skipToken(uriParserResultView.getSkipToken());
        if (uriParserResultView.getSkip() != null) {
            pageBuilder.skip(uriParserResultView.getSkip());
        }
        if (uriParserResultView.getTop() != null) {
            pageBuilder.top(uriParserResultView.getTop());
        }
        JPAPage page = pageBuilder.build();
        this.oDataJPAContext.setPaging((JPAPaging)page);
        return page.getPagedEntities();
    }

    private boolean setTransaction() {
        ODataJPATransaction transaction = this.oDataJPAContext.getODataJPATransaction();
        if (!transaction.isActive()) {
            transaction.begin();
            return true;
        }
        return false;
    }
}

