/*
 * Decompiled with CFR 0.152.
 */
package kafka.log.remote;

import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import kafka.log.remote.RemoteLogManager;
import kafka.server.BrokerTopicStats;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.RemoteLogReadResult;
import org.apache.kafka.storage.internals.log.RemoteStorageFetchInfo;
import org.slf4j.Logger;

public class RemoteLogReader
implements Callable<Void> {
    private final Logger logger;
    private final RemoteStorageFetchInfo fetchInfo;
    private final RemoteLogManager rlm;
    private final BrokerTopicStats brokerTopicStats;
    private final Consumer<RemoteLogReadResult> callback;

    public RemoteLogReader(RemoteStorageFetchInfo fetchInfo, RemoteLogManager rlm, Consumer<RemoteLogReadResult> callback, BrokerTopicStats brokerTopicStats) {
        this.fetchInfo = fetchInfo;
        this.rlm = rlm;
        this.brokerTopicStats = brokerTopicStats;
        this.callback = callback;
        this.brokerTopicStats.topicStats(fetchInfo.topicPartition.topic()).remoteFetchRequestRate().mark();
        this.brokerTopicStats.allTopicsStats().remoteFetchRequestRate().mark();
        this.logger = new LogContext(){

            public String logPrefix() {
                return "[" + Thread.currentThread().getName() + "]";
            }
        }.logger(RemoteLogReader.class);
    }

    @Override
    public Void call() {
        RemoteLogReadResult result;
        try {
            this.logger.debug("Reading records from remote storage for topic partition {}", (Object)this.fetchInfo.topicPartition);
            FetchDataInfo fetchDataInfo = this.rlm.read(this.fetchInfo);
            this.brokerTopicStats.topicStats(this.fetchInfo.topicPartition.topic()).remoteFetchBytesRate().mark((long)fetchDataInfo.records.sizeInBytes());
            this.brokerTopicStats.allTopicsStats().remoteFetchBytesRate().mark((long)fetchDataInfo.records.sizeInBytes());
            result = new RemoteLogReadResult(Optional.of(fetchDataInfo), Optional.empty());
        }
        catch (OffsetOutOfRangeException e) {
            result = new RemoteLogReadResult(Optional.empty(), Optional.of(e));
        }
        catch (Exception e) {
            this.brokerTopicStats.topicStats(this.fetchInfo.topicPartition.topic()).failedRemoteFetchRequestRate().mark();
            this.brokerTopicStats.allTopicsStats().failedRemoteFetchRequestRate().mark();
            this.logger.error("Error occurred while reading the remote data for {}", (Object)this.fetchInfo.topicPartition, (Object)e);
            result = new RemoteLogReadResult(Optional.empty(), Optional.of(e));
        }
        this.logger.debug("Finished reading records from remote storage for topic partition {}", (Object)this.fetchInfo.topicPartition);
        this.callback.accept(result);
        return null;
    }
}

