/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.raft.ElectionState;
import org.apache.kafka.raft.EpochState;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.slf4j.Logger;

public class CandidateState
implements EpochState {
    private final int localId;
    private final int epoch;
    private final int retries;
    private final Map<Integer, State> voteStates = new HashMap<Integer, State>();
    private final Optional<LogOffsetMetadata> highWatermark;
    private final int electionTimeoutMs;
    private final Timer electionTimer;
    private final Timer backoffTimer;
    private final Logger log;
    private boolean isBackingOff;

    protected CandidateState(Time time, int localId, int epoch, Set<Integer> voters, Optional<LogOffsetMetadata> highWatermark, int retries, int electionTimeoutMs, LogContext logContext) {
        this.localId = localId;
        this.epoch = epoch;
        this.highWatermark = highWatermark;
        this.retries = retries;
        this.isBackingOff = false;
        this.electionTimeoutMs = electionTimeoutMs;
        this.electionTimer = time.timer((long)electionTimeoutMs);
        this.backoffTimer = time.timer(0L);
        this.log = logContext.logger(CandidateState.class);
        for (Integer voterId : voters) {
            this.voteStates.put(voterId, State.UNRECORDED);
        }
        this.voteStates.put(localId, State.GRANTED);
    }

    public int localId() {
        return this.localId;
    }

    public int majoritySize() {
        return this.voteStates.size() / 2 + 1;
    }

    private long numGranted() {
        return this.voteStates.values().stream().filter(state -> state == State.GRANTED).count();
    }

    private long numUnrecorded() {
        return this.voteStates.values().stream().filter(state -> state == State.UNRECORDED).count();
    }

    public boolean isBackingOff() {
        return this.isBackingOff;
    }

    public int retries() {
        return this.retries;
    }

    public boolean isVoteGranted() {
        return this.numGranted() >= (long)this.majoritySize();
    }

    public boolean isVoteRejected() {
        return this.numGranted() + this.numUnrecorded() < (long)this.majoritySize();
    }

    public boolean recordGrantedVote(int remoteNodeId) {
        State state = this.voteStates.get(remoteNodeId);
        if (state == null) {
            throw new IllegalArgumentException("Attempt to grant vote to non-voter " + remoteNodeId);
        }
        if (state == State.REJECTED) {
            throw new IllegalArgumentException("Attempt to grant vote from node " + remoteNodeId + " which previously rejected our request");
        }
        return this.voteStates.put(remoteNodeId, State.GRANTED) == State.UNRECORDED;
    }

    public boolean recordRejectedVote(int remoteNodeId) {
        State state = this.voteStates.get(remoteNodeId);
        if (state == null) {
            throw new IllegalArgumentException("Attempt to reject vote to non-voter " + remoteNodeId);
        }
        if (state == State.GRANTED) {
            throw new IllegalArgumentException("Attempt to reject vote from node " + remoteNodeId + " which previously granted our request");
        }
        return this.voteStates.put(remoteNodeId, State.REJECTED) == State.UNRECORDED;
    }

    public void startBackingOff(long currentTimeMs, long backoffDurationMs) {
        this.backoffTimer.update(currentTimeMs);
        this.backoffTimer.reset(backoffDurationMs);
        this.isBackingOff = true;
    }

    public Set<Integer> unrecordedVoters() {
        return this.votersInState(State.UNRECORDED);
    }

    public Set<Integer> grantingVoters() {
        return this.votersInState(State.GRANTED);
    }

    public Set<Integer> rejectingVoters() {
        return this.votersInState(State.REJECTED);
    }

    private Set<Integer> votersInState(State state) {
        return this.voteStates.entrySet().stream().filter(entry -> entry.getValue() == state).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public boolean hasElectionTimeoutExpired(long currentTimeMs) {
        this.electionTimer.update(currentTimeMs);
        return this.electionTimer.isExpired();
    }

    public boolean isBackoffComplete(long currentTimeMs) {
        this.backoffTimer.update(currentTimeMs);
        return this.backoffTimer.isExpired();
    }

    public long remainingBackoffMs(long currentTimeMs) {
        if (!this.isBackingOff) {
            throw new IllegalStateException("Candidate is not currently backing off");
        }
        this.backoffTimer.update(currentTimeMs);
        return this.backoffTimer.remainingMs();
    }

    public long remainingElectionTimeMs(long currentTimeMs) {
        this.electionTimer.update(currentTimeMs);
        return this.electionTimer.remainingMs();
    }

    @Override
    public ElectionState election() {
        return ElectionState.withVotedCandidate(this.epoch, this.localId, this.voteStates.keySet());
    }

    @Override
    public int epoch() {
        return this.epoch;
    }

    @Override
    public Optional<LogOffsetMetadata> highWatermark() {
        return this.highWatermark;
    }

    @Override
    public boolean canGrantVote(int candidateId, boolean isLogUpToDate) {
        this.log.debug("Rejecting vote request from candidate {} since we are already candidate in epoch {}", (Object)candidateId, (Object)this.epoch);
        return false;
    }

    public String toString() {
        return "CandidateState(localId=" + this.localId + ", epoch=" + this.epoch + ", retries=" + this.retries + ", voteStates=" + this.voteStates + ", highWatermark=" + this.highWatermark + ", electionTimeoutMs=" + this.electionTimeoutMs + ')';
    }

    @Override
    public String name() {
        return "Candidate";
    }

    @Override
    public void close() {
    }

    private static enum State {
        UNRECORDED,
        GRANTED,
        REJECTED;

    }
}

