/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.intl;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.lang3.StringUtils;

@JsxClass
public class NumberFormat
extends HtmlUnitScriptable {
    private static final ConcurrentHashMap<String, String> CHROME_FORMATS_ = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> EDGE_FORMATS_ = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> FF_FORMATS_ = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> FF_ESR_FORMATS_ = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> IE_FORMATS_ = new ConcurrentHashMap();
    private transient NumberFormatHelper formatter_;

    public NumberFormat() {
    }

    private NumberFormat(String[] locales, BrowserVersion browserVersion) {
        ConcurrentHashMap<String, String> formats = browserVersion.isChrome() ? CHROME_FORMATS_ : (browserVersion.isEdge() ? EDGE_FORMATS_ : (browserVersion.isIE() ? IE_FORMATS_ : (browserVersion.isFirefoxESR() ? FF_ESR_FORMATS_ : FF_FORMATS_)));
        String locale = "";
        String pattern = null;
        for (String l : locales) {
            pattern = NumberFormat.getPattern(formats, l);
            if (pattern == null) continue;
            locale = l;
        }
        if (pattern == null) {
            pattern = (String)formats.get("");
            if (locales.length > 0) {
                locale = locales[0];
            }
        }
        this.formatter_ = new NumberFormatHelper(locale, browserVersion, pattern);
    }

    private static String getPattern(Map<String, String> formats, String locale) {
        if ("no-NO-NY".equals(locale)) {
            throw ScriptRuntime.rangeError((String)("Invalid language tag: " + locale));
        }
        String pattern = formats.get(locale);
        if (pattern == null && locale.indexOf(45) != -1) {
            pattern = formats.get(locale.substring(0, locale.indexOf(45)));
        }
        return pattern;
    }

    @JsxConstructor
    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        String[] locales;
        if (args.length != 0) {
            if (args[0] instanceof NativeArray) {
                NativeArray array = (NativeArray)args[0];
                locales = new String[(int)array.getLength()];
                for (int i = 0; i < locales.length; ++i) {
                    locales[i] = Context.toString((Object)array.get(i));
                }
            } else {
                locales = new String[]{Context.toString((Object)args[0])};
            }
        } else {
            locales = new String[]{""};
        }
        Window window = NumberFormat.getWindow((Scriptable)ctorObj);
        NumberFormat format = new NumberFormat(locales, window.getBrowserVersion());
        format.setParentScope((Scriptable)window);
        format.setPrototype(window.getPrototype(format.getClass()));
        return format;
    }

    @JsxFunction
    public String format(Object object) {
        double number = Context.toNumber((Object)object);
        return this.formatter_.format(number);
    }

    @JsxFunction
    public Scriptable resolvedOptions() {
        return Context.getCurrentContext().newObject(this.getParentScope());
    }

    static {
        HashMap<String, String> commonFormats = new HashMap<String, String>();
        commonFormats.put("", "");
        commonFormats.put("ar", "\u066c\u066b\u0660");
        commonFormats.put("ar-DZ", ".,");
        commonFormats.put("ar-LY", ".,");
        commonFormats.put("ar-MA", ".,");
        commonFormats.put("ar-TN", ".,");
        commonFormats.put("id", ".,");
        commonFormats.put("de-AT", "\u00a0");
        commonFormats.put("de-CH", "\u2019");
        commonFormats.put("en-ZA", "\u00a0,");
        commonFormats.put("es-CR", "\u00a0,");
        commonFormats.put("fr-LU", ".,");
        commonFormats.put("hi-IN", ",.0");
        commonFormats.put("it-CH", "\u2019");
        commonFormats.put("pt-PT", "\u00a0,");
        commonFormats.put("sq", "\u00a0,");
        IE_FORMATS_.putAll(commonFormats);
        IE_FORMATS_.put("ar-DZ", ",.");
        IE_FORMATS_.put("ar-LY", ",.");
        IE_FORMATS_.put("ar-MA", ",.");
        IE_FORMATS_.put("ar-TN", ",.");
        IE_FORMATS_.put("fr", "\u00a0,");
        IE_FORMATS_.put("fr-BE", ".");
        IE_FORMATS_.put("ban", ".,");
        commonFormats.put("ar-AE", ",.0");
        commonFormats.put("fr", "\u202f,");
        commonFormats.put("fr-CA", "\u00a0,");
        FF_FORMATS_.putAll(commonFormats);
        FF_ESR_FORMATS_.putAll(commonFormats);
        commonFormats.put("ar", ",.0");
        commonFormats.put("ar-BH", "\u066c\u066b\u0660");
        commonFormats.put("ar-EG", "\u066c\u066b\u0660");
        commonFormats.put("ar-IQ", "\u066c\u066b\u0660");
        commonFormats.put("ar-JO", "\u066c\u066b\u0660");
        commonFormats.put("ar-KW", "\u066c\u066b\u0660");
        commonFormats.put("ar-LB", "\u066c\u066b\u0660");
        commonFormats.put("ar-OM", "\u066c\u066b\u0660");
        commonFormats.put("ar-QA", "\u066c\u066b\u0660");
        commonFormats.put("ar-SA", "\u066c\u066b\u0660");
        commonFormats.put("ar-SD", "\u066c\u066b\u0660");
        commonFormats.put("ar-SY", "\u066c\u066b\u0660");
        commonFormats.put("ar-YE", "\u066c\u066b\u0660");
        CHROME_FORMATS_.putAll(commonFormats);
        EDGE_FORMATS_.putAll(commonFormats);
        CHROME_FORMATS_.put("be", ",.");
        CHROME_FORMATS_.put("mk", ",.");
        CHROME_FORMATS_.put("is", ",.");
        CHROME_FORMATS_.put("sq", ",.");
    }

    static final class NumberFormatHelper {
        private DecimalFormat formatter_;

        NumberFormatHelper(String localeName, BrowserVersion browserVersion, String pattern) {
            Locale locale = browserVersion.getBrowserLocale();
            if (StringUtils.isNotEmpty((CharSequence)localeName)) {
                locale = Locale.forLanguageTag(localeName);
            }
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
            if (pattern.length() > 0) {
                char groupingSeparator = pattern.charAt(0);
                if (groupingSeparator != ' ') {
                    symbols.setGroupingSeparator(groupingSeparator);
                }
                if (pattern.length() > 1) {
                    char zeroDigit;
                    char decimalSeparator = pattern.charAt(1);
                    if (decimalSeparator != ' ') {
                        symbols.setDecimalSeparator(decimalSeparator);
                    }
                    if (pattern.length() > 2 && (zeroDigit = pattern.charAt(2)) != ' ') {
                        symbols.setZeroDigit(zeroDigit);
                    }
                }
            }
            this.formatter_ = new DecimalFormat("#,##0.###", symbols);
        }

        String format(double number) {
            return this.formatter_.format(number);
        }
    }
}

